/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemBase;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.OSSUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public final class PreprocessMessageInput {
    public static boolean checkAndUpload(String model, MultiModalMessageItemBase message, String apiKey) throws NoApiKeyException, UploadFileException {
        boolean isUpload = false;
        if (message.getContent().startsWith("file://")) {
            try {
                String fileUrl;
                URI fileURI = new URI(message.getContent());
                File f = new File(fileURI);
                if (f.exists()) {
                    fileUrl = OSSUtils.upload(model, f.getAbsolutePath(), apiKey);
                    if (fileUrl == null) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", message.getContent()));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", message.getContent()));
                }
                message.setContent(fileUrl);
                isUpload = true;
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        }
        return isUpload;
    }

    public static <T extends MultiModalMessageItemBase> boolean preProcessMessageInputs(String model, List<T> messages, String apiKey) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        for (MultiModalMessageItemBase elem : messages) {
            boolean isUpload = PreprocessMessageInput.checkAndUpload(model, elem, apiKey);
            if (!isUpload || hasUpload) continue;
            hasUpload = true;
        }
        return hasUpload;
    }
}

