/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerSchemaStatVisitor;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.List;

public class SQLUtils {
    private static final Log LOG = LogFactory.getLog(SQLUtils.class);

    public static String toSQLString(SQLObject sqlObject, String dbType) {
        if ("mysql".equals(dbType)) {
            return SQLUtils.toMySqlString(sqlObject);
        }
        if ("h2".equals(dbType)) {
            return SQLUtils.toMySqlString(sqlObject);
        }
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return SQLUtils.toOracleString(sqlObject);
        }
        if ("postgresql".equals(dbType)) {
            return SQLUtils.toPGString(sqlObject);
        }
        return SQLUtils.toSQLServerString(sqlObject);
    }

    public static String toSQLString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new SQLASTOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String toMySqlString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new MySqlOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static SQLExpr toMySqlExpr(String sql) {
        return SQLUtils.toSQLExpr(sql, "mysql");
    }

    public static String formatMySql(String sql) {
        return SQLUtils.format(sql, "mysql");
    }

    public static String formatOracle(String sql) {
        return SQLUtils.format(sql, "oracle");
    }

    public static String toOracleString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new OracleOutputVisitor(out, false));
        String sql = out.toString();
        return sql;
    }

    public static String toPGString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new PGOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String toSQLServerString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new SQLServerOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String formatPGSql(String sql) {
        return SQLUtils.format(sql, "postgresql");
    }

    public static SQLExpr toSQLExpr(String sql, String dbType) {
        SQLExprParser parser = SQLParserUtils.createExprParser(sql, dbType);
        SQLExpr expr = parser.expr();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return expr;
    }

    public static List<SQLStatement> toStatementList(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        return parser.parseStatementList();
    }

    public static SQLExpr toSQLExpr(String sql) {
        return SQLUtils.toSQLExpr(sql, null);
    }

    public static String format(String sql, String dbType) {
        return SQLUtils.format(sql, dbType, null);
    }

    public static String format(String sql, String dbType, List<Object> parameters) {
        try {
            List<SQLStatement> statementList = SQLUtils.toStatementList(sql, dbType);
            return SQLUtils.toSQLString(statementList, dbType, parameters);
        }
        catch (SQLParseException ex) {
            LOG.warn("format error", ex);
            return sql;
        }
        catch (ParserException ex) {
            LOG.warn("format error", ex);
            return sql;
        }
    }

    public static String toSQLString(List<SQLStatement> statementList, String dbType) {
        return SQLUtils.toSQLString(statementList, dbType, null);
    }

    public static String toSQLString(List<SQLStatement> statementList, String dbType, List<Object> parameters) {
        StringBuilder out = new StringBuilder();
        SQLASTOutputVisitor visitor = SQLUtils.createFormatOutputVisitor(out, statementList, dbType);
        if (parameters != null) {
            visitor.setParameters(parameters);
        }
        for (SQLStatement stmt : statementList) {
            stmt.accept(visitor);
        }
        return out.toString();
    }

    public static SQLASTOutputVisitor createFormatOutputVisitor(Appendable out, List<SQLStatement> statementList, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            if (statementList.size() == 1) {
                return new OracleOutputVisitor(out, false);
            }
            return new OracleOutputVisitor(out, true);
        }
        if ("mysql".equals(dbType)) {
            return new MySqlOutputVisitor(out);
        }
        if ("postgresql".equals(dbType)) {
            return new PGOutputVisitor(out);
        }
        if ("sqlserver".equals(dbType)) {
            return new SQLServerOutputVisitor(out);
        }
        if ("jtds".equals(dbType)) {
            return new SQLServerOutputVisitor(out);
        }
        if ("h2".equals(dbType)) {
            return new MySqlOutputVisitor(out);
        }
        return new SQLASTOutputVisitor(out);
    }

    public static SchemaStatVisitor createSchemaStatVisitor(List<SQLStatement> statementList, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            if (statementList.size() == 1) {
                return new OracleSchemaStatVisitor();
            }
            return new OracleSchemaStatVisitor();
        }
        if ("mysql".equals(dbType)) {
            return new MySqlSchemaStatVisitor();
        }
        if ("postgresql".equals(dbType)) {
            return new PGSchemaStatVisitor();
        }
        if ("sqlserver".equals(dbType)) {
            return new SQLServerSchemaStatVisitor();
        }
        if ("jtds".equals(dbType)) {
            return new SQLServerSchemaStatVisitor();
        }
        if ("h2".equals(dbType)) {
            return new MySqlSchemaStatVisitor();
        }
        return new SchemaStatVisitor();
    }

    public static List<SQLStatement> parseStatements(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        List<SQLStatement> stmtList = parser.parseStatementList();
        if (parser.getLexer().token() != Token.EOF) {
            throw new DruidRuntimeException("syntax error : " + sql);
        }
        return stmtList;
    }
}

