/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilterMBean;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallSQLException;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.alibaba.druid.wall.spi.OracleWallProvider;
import com.alibaba.druid.wall.spi.SQLServerProvider;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class WallFilter
extends FilterAdapter
implements WallFilterMBean {
    private static final Log LOG = LogFactory.getLog(WallFilter.class);
    private boolean inited = false;
    private WallProvider provider;
    private String dbType;
    private WallConfig config;
    private volatile boolean logViolation = false;
    private volatile boolean throwException = true;
    private final AtomicLong violationCount = new AtomicLong();

    @Override
    public void init(DataSourceProxy dataSource) {
        if (this.dbType == null || this.dbType.trim().length() == 0) {
            this.dbType = dataSource != null && dataSource.getDbType() != null ? dataSource.getDbType() : JdbcUtils.getDbType(dataSource.getRawJdbcUrl(), "");
        }
        if (this.dbType == null) {
            this.dbType = JdbcUtils.getDbType(dataSource.getUrl(), null);
        }
        if ("mysql".equals(this.dbType) || "h2".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/mysql");
            }
            this.provider = new MySqlWallProvider(this.config);
        } else if ("oracle".equals(this.dbType) || "AliOracle".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/oracle");
            }
            this.provider = new OracleWallProvider(this.config);
        } else if ("sqlserver".equals(this.dbType) || "jtds".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/sqlserver");
            }
            this.provider = new SQLServerProvider(this.config);
        } else {
            throw new IllegalStateException("dbType not support : " + this.dbType + ", url " + dataSource.getUrl());
        }
        this.inited = true;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean isLogViolation() {
        return this.logViolation;
    }

    @Override
    public void setLogViolation(boolean logViolation) {
        this.logViolation = logViolation;
    }

    @Override
    public boolean isThrowException() {
        return this.throwException;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public void clearProviderCache() {
        if (this.provider != null) {
            this.provider.clearCache();
        }
    }

    @Override
    public Set<String> getProviderWhiteList() {
        if (this.provider == null) {
            return Collections.emptySet();
        }
        return this.provider.getWhiteList();
    }

    public WallProvider getProvider() {
        return this.provider;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    public void setConfig(WallConfig config) {
        this.config = config;
    }

    @Override
    public boolean isInited() {
        return this.inited;
    }

    public void checkInit() {
        if (this.inited) {
            throw new DruidRuntimeException("wall filter is inited");
        }
    }

    @Override
    public void statement_addBatch(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        sql = this.check(sql);
        chain.statement_addBatch(statement, sql);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareStatement(connection, sql);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int autoGeneratedKeys) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareStatement(connection, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int[] columnIndexes) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareStatement(connection, sql, columnIndexes);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, String[] columnNames) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareStatement(connection, sql, columnNames);
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareCall(connection, sql);
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        sql = this.check(sql);
        return chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        sql = this.check(sql);
        return chain.statement_execute(statement, sql);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        sql = this.check(sql);
        return chain.statement_execute(statement, sql, autoGeneratedKeys);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        sql = this.check(sql);
        return chain.statement_execute(statement, sql, columnIndexes);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        sql = this.check(sql);
        return chain.statement_execute(statement, sql, columnNames);
    }

    @Override
    public ResultSetProxy statement_executeQuery(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        sql = this.check(sql);
        return chain.statement_executeQuery(statement, sql);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        sql = this.check(sql);
        return chain.statement_executeUpdate(statement, sql);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        sql = this.check(sql);
        return chain.statement_executeUpdate(statement, sql, autoGeneratedKeys);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        sql = this.check(sql);
        return chain.statement_executeUpdate(statement, sql, columnIndexes);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        sql = this.check(sql);
        return chain.statement_executeUpdate(statement, sql, columnNames);
    }

    @Override
    public String check(String sql) throws SQLException {
        WallCheckResult checkResult = this.provider.check(sql);
        List<Violation> violations = checkResult.getViolations();
        if (violations.size() > 0) {
            this.violationCount.incrementAndGet();
            if (this.isLogViolation()) {
                LOG.error("sql injection violation : " + sql);
            }
            if (this.throwException) {
                if (violations.get(0) instanceof SyntaxErrorViolation) {
                    SyntaxErrorViolation violation = (SyntaxErrorViolation)violations.get(0);
                    throw new SQLException("sql injection violation : " + sql, violation.getException());
                }
                throw new SQLException("sql injection violation : " + sql);
            }
        }
        return sql;
    }

    @Override
    public boolean isWrapperFor(FilterChain chain, Wrapper wrapper, Class<?> iface) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return chain.isWrapperFor(wrapper, iface);
        }
        if (!this.provider.getConfig().isWrapAllow()) {
            return false;
        }
        return chain.isWrapperFor(wrapper, iface);
    }

    @Override
    public <T> T unwrap(FilterChain chain, Wrapper wrapper, Class<T> iface) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return chain.unwrap(wrapper, iface);
        }
        if (!this.provider.getConfig().isWrapAllow()) {
            this.violationCount.incrementAndGet();
            return null;
        }
        return chain.unwrap(wrapper, iface);
    }

    @Override
    public DatabaseMetaData connection_getMetaData(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return chain.connection_getMetaData(connection);
        }
        if (!this.provider.getConfig().isMetadataAllow()) {
            this.violationCount.incrementAndGet();
            if (this.isLogViolation()) {
                LOG.error("not support method : Connection.getMetdataData");
            }
            if (this.throwException) {
                throw new WallSQLException("not support method : Connection.getMetdataData");
            }
        }
        return chain.connection_getMetaData(connection);
    }

    @Override
    public long getViolationCount() {
        return this.violationCount.get();
    }
}

