/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.util.LRUCache;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class WallProvider {
    private static final Object PRESENT = new Object();
    private LinkedHashMap<String, Object> whiteList;
    private int whileListMaxSize = 1024;
    private int whiteSqlMaxLength = 1024;
    protected final WallConfig config;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ThreadLocal<Boolean> privileged = new ThreadLocal();
    private static final ThreadLocal<Object> tenantValueLocal = new ThreadLocal();

    public WallProvider(WallConfig config) {
        this.config = config;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhiteSql(String sql) {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList == null) {
                this.whiteList = new LRUCache<String, Object>(this.whileListMaxSize);
            }
            this.whiteList.put(sql, PRESENT);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWhiteList() {
        HashSet<String> hashSet = new HashSet<String>();
        this.lock.readLock().lock();
        try {
            if (this.whiteList != null) {
                hashSet.addAll(this.whiteList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList != null) {
                this.whiteList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean whiteContains(String sql) {
        this.lock.readLock().lock();
        try {
            if (this.whiteList == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.whiteList.get(sql) != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public abstract SQLStatementParser createParser(String var1);

    public abstract WallVisitor createWallVisitor();

    public abstract ExportParameterVisitor createExportParameterVisitor();

    public boolean checkValid(String sql) {
        return this.check(sql).getViolations().isEmpty();
    }

    public WallCheckResult check(String sql) {
        WallCheckResult result = new WallCheckResult();
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return result;
        }
        boolean isWhite = this.whiteContains(sql);
        if (isWhite) {
            return result;
        }
        SQLStatementParser parser = this.createParser(sql);
        if (!this.config.isCommentAllow()) {
            parser.getLexer().setAllowComment(false);
        }
        try {
            parser.parseStatementList(result.getStatementList());
        }
        catch (Exception e) {
            result.getViolations().add(new SyntaxErrorViolation(e, sql));
            return result;
        }
        if (parser.getLexer().token() != Token.EOF) {
            result.getViolations().add(new IllegalSQLObjectViolation(sql));
            return result;
        }
        if (result.getStatementList().size() == 0) {
            return result;
        }
        if (result.getStatementList().size() > 1 && !this.config.isMultiStatementAllow()) {
            result.getViolations().add(new IllegalSQLObjectViolation(sql));
            return result;
        }
        SQLStatement stmt = result.getStatementList().get(0);
        WallVisitor visitor = this.createWallVisitor();
        try {
            stmt.accept(visitor);
        }
        catch (ParserException e) {
            result.getViolations().add(new IllegalSQLObjectViolation(sql));
            return result;
        }
        if (visitor.getViolations().size() == 0 && sql.length() < this.whiteSqlMaxLength) {
            this.addWhiteSql(sql);
        }
        result.getViolations().addAll(visitor.getViolations());
        return result;
    }

    public static boolean ispPivileged() {
        Boolean value = privileged.get();
        if (value == null) {
            return false;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        privileged.set(Boolean.TRUE);
        try {
            T t = action.run();
            return t;
        }
        finally {
            privileged.set(null);
        }
    }

    public static void setTenantValue(Object value) {
        tenantValueLocal.set(value);
    }

    public static Object getTenantValue() {
        return tenantValueLocal.get();
    }
}

