/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.SQLTableDataType;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateViewStatement
extends SQLStatementImpl
implements SQLCreateStatement {
    private boolean orReplace = false;
    private boolean force = false;
    protected SQLSelect subQuery;
    protected boolean ifNotExists = false;
    protected String algorithm;
    protected SQLName definer;
    protected String sqlSecurity;
    protected SQLExprTableSource tableSource;
    protected final List<SQLTableElement> columns = new ArrayList<SQLTableElement>();
    private boolean withCheckOption;
    private boolean withCascaded;
    private boolean withLocal;
    private boolean withReadOnly;
    private SQLLiteralExpr comment;
    private SQLVariantRefExpr returns;
    private SQLTableDataType returnsDataType;
    protected boolean onCluster;
    private SQLName to;
    private SQLBlockStatement script;

    public SQLCreateViewStatement() {
    }

    public SQLCreateViewStatement(DbType dbType) {
        super(dbType);
    }

    public String computeName() {
        if (this.tableSource == null) {
            return null;
        }
        SQLExpr expr = this.tableSource.getExpr();
        if (expr instanceof SQLName) {
            String name = ((SQLName)expr).getSimpleName();
            return SQLUtils.normalize(name);
        }
        return null;
    }

    public String getSchema() {
        SQLName name = this.getName();
        if (name == null) {
            return null;
        }
        if (name instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)name).getOwnernName();
        }
        return null;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public SQLName getName() {
        if (this.tableSource == null) {
            return null;
        }
        return (SQLName)this.tableSource.getExpr();
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public void setName(String name) {
        this.setName(new SQLIdentifierExpr(name));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public boolean isWithCheckOption() {
        return this.withCheckOption;
    }

    public void setWithCheckOption(boolean withCheckOption) {
        this.withCheckOption = withCheckOption;
    }

    public boolean isWithCascaded() {
        return this.withCascaded;
    }

    public void setWithCascaded(boolean withCascaded) {
        this.withCascaded = withCascaded;
    }

    public boolean isWithLocal() {
        return this.withLocal;
    }

    public void setWithLocal(boolean withLocal) {
        this.withLocal = withLocal;
    }

    public boolean isWithReadOnly() {
        return this.withReadOnly;
    }

    public void setWithReadOnly(boolean withReadOnly) {
        this.withReadOnly = withReadOnly;
    }

    public SQLSelect getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(SQLSelect subQuery) {
        if (subQuery != null) {
            subQuery.setParent(this);
        }
        this.subQuery = subQuery;
    }

    public List<SQLTableElement> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLTableElement column) {
        if (column != null) {
            column.setParent(this);
        }
        this.columns.add(column);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public SQLLiteralExpr getComment() {
        return this.comment;
    }

    public void setComment(SQLLiteralExpr comment) {
        if (comment != null) {
            comment.setParent(this);
        }
        this.comment = comment;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public SQLName getDefiner() {
        return this.definer;
    }

    public void setDefiner(SQLName definer) {
        if (definer != null) {
            definer.setParent(this);
        }
        this.definer = definer;
    }

    public String getSqlSecurity() {
        return this.sqlSecurity;
    }

    public void setSqlSecurity(String sqlSecurity) {
        this.sqlSecurity = sqlSecurity;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.tableSource != null) {
                this.tableSource.accept(visitor);
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                SQLTableElement column = this.columns.get(i);
                if (column == null) continue;
                column.accept(visitor);
            }
            if (this.comment != null) {
                this.comment.accept(visitor);
            }
            if (this.subQuery != null) {
                this.subQuery.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        if (this.tableSource != null) {
            children.add(this.tableSource);
        }
        children.addAll(this.columns);
        if (this.comment != null) {
            children.add(this.comment);
        }
        if (this.subQuery != null) {
            children.add(this.subQuery);
        }
        return children;
    }

    public boolean isOnCluster() {
        return this.onCluster;
    }

    public void setOnCluster(boolean onCluster) {
        this.onCluster = onCluster;
    }

    public SQLName getTo() {
        return this.to;
    }

    public void setTo(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.to = x;
    }

    public SQLVariantRefExpr getReturns() {
        return this.returns;
    }

    public void setReturns(SQLVariantRefExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.returns = x;
    }

    public SQLTableDataType getReturnsDataType() {
        return this.returnsDataType;
    }

    public void setReturnsDataType(SQLTableDataType x) {
        if (x != null) {
            x.setParent(this);
        }
        this.returnsDataType = x;
    }

    public SQLBlockStatement getScript() {
        return this.script;
    }

    public void setScript(SQLBlockStatement x) {
        if (x != null) {
            x.setParent(this);
        }
        this.script = x;
    }

    @Override
    public SQLCreateViewStatement clone() {
        SQLCreateViewStatement x = new SQLCreateViewStatement();
        x.orReplace = this.orReplace;
        x.force = this.force;
        if (this.subQuery != null) {
            x.setSubQuery(this.subQuery.clone());
        }
        x.ifNotExists = this.ifNotExists;
        x.algorithm = this.algorithm;
        if (this.definer != null) {
            x.setDefiner(this.definer.clone());
        }
        x.sqlSecurity = this.sqlSecurity;
        if (this.tableSource != null) {
            x.setTableSource(this.tableSource.clone());
        }
        for (SQLTableElement column : this.columns) {
            SQLTableElement column2 = column.clone();
            column2.setParent(x);
            x.columns.add(column2);
        }
        x.withCheckOption = this.withCheckOption;
        x.withCascaded = this.withCascaded;
        x.withLocal = this.withLocal;
        x.withReadOnly = this.withReadOnly;
        if (this.comment != null) {
            x.setComment(this.comment.clone());
        }
        x.onCluster = this.onCluster;
        if (x.to != null) {
            this.to = x.to.clone();
        }
        if (x.returns != null) {
            this.returns = x.returns.clone();
        }
        if (x.returnsDataType != null) {
            this.returnsDataType = x.returnsDataType.clone();
        }
        return x;
    }

    public static class Column
    extends SQLObjectImpl {
        private SQLExpr expr;
        private SQLCharExpr comment;

        public SQLExpr getExpr() {
            return this.expr;
        }

        public void setExpr(SQLExpr expr) {
            if (expr != null) {
                expr.setParent(this);
            }
            this.expr = expr;
        }

        public SQLCharExpr getComment() {
            return this.comment;
        }

        public void setComment(SQLCharExpr comment) {
            if (comment != null) {
                comment.setParent(this);
            }
            this.comment = comment;
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.expr);
                this.acceptChild(visitor, this.comment);
            }
        }
    }

    public static enum Level {
        CASCADED,
        LOCAL;

    }
}

