/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.DbType;
import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.repository.Schema;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaObjectType;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.repository.SchemaResolveVisitorFactory;
import com.alibaba.druid.sql.repository.function.Function;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.FnvHash;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SchemaRepository {
    private static Log LOG = LogFactory.getLog(SchemaRepository.class);
    private Schema defaultSchema;
    protected DbType dbType;
    protected DbType schemaDbType;
    protected SQLASTVisitor consoleVisitor;
    protected Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();
    protected final Map<Long, Function> internalFunctions = new ConcurrentHashMap<Long, Function>(16, 0.75f, 1);
    protected SchemaLoader schemaLoader;

    public SchemaRepository() {
    }

    public SchemaRepository(DbType dbType) {
        this(dbType, dbType);
    }

    public SchemaRepository(DbType dbType, DbType schemaDbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        if (schemaDbType == null) {
            schemaDbType = dbType;
        }
        this.dbType = dbType;
        this.schemaDbType = schemaDbType;
        switch (dbType) {
            case mysql: {
                this.consoleVisitor = new MySqlConsoleSchemaVisitor();
                break;
            }
            case oracle: {
                this.consoleVisitor = new OracleConsoleSchemaVisitor();
                break;
            }
            default: {
                this.consoleVisitor = new DefaultConsoleSchemaVisitor();
            }
        }
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getDefaultSchemaName() {
        return this.getDefaultSchema().getName();
    }

    public void setDefaultSchema(String name) {
        if (name == null) {
            this.defaultSchema = null;
            return;
        }
        String normalizedName = SQLUtils.normalize(name).toLowerCase();
        Schema defaultSchema = this.schemas.get(normalizedName);
        if (defaultSchema != null) {
            this.defaultSchema = defaultSchema;
            return;
        }
        if (this.defaultSchema != null && this.defaultSchema.getName() == null) {
            this.defaultSchema.setName(name);
            this.schemas.put(normalizedName, this.defaultSchema);
            return;
        }
        defaultSchema = new Schema(this);
        defaultSchema.setName(name);
        this.schemas.put(normalizedName, defaultSchema);
        this.defaultSchema = defaultSchema;
    }

    public Schema findSchema(String schema) {
        return this.findSchema(schema, false);
    }

    protected Schema findSchema(String name, boolean create) {
        if (name == null || name.length() == 0) {
            return this.getDefaultSchema();
        }
        name = SQLUtils.normalize(name);
        String normalizedName = name.toLowerCase();
        if (this.getDefaultSchema() != null && this.defaultSchema.getName() == null && create) {
            this.defaultSchema.setName(name);
            this.schemas.put(normalizedName, this.defaultSchema);
            return this.defaultSchema;
        }
        Schema schema = this.schemas.get(normalizedName);
        if (schema == null && create) {
            int p = name.indexOf(46);
            String catalog = null;
            if (p != -1) {
                catalog = name.substring(0, p);
            }
            schema = new Schema(this, catalog, name);
            this.schemas.put(normalizedName, schema);
        }
        return schema;
    }

    public Schema getDefaultSchema() {
        if (this.defaultSchema == null) {
            this.defaultSchema = new Schema(this);
        }
        return this.defaultSchema;
    }

    public void setDefaultSchema(Schema schema) {
        this.defaultSchema = schema;
    }

    public SchemaObject findTable(String tableName) {
        SchemaObject schemaObject;
        SQLExpr expr;
        if (tableName.indexOf(46) != -1 && !((expr = SQLUtils.toSQLExpr(tableName, this.dbType)) instanceof SQLIdentifierExpr)) {
            return this.findTable((SQLName)expr);
        }
        SchemaObject object = this.getDefaultSchema().findTable(tableName);
        if (object != null) {
            return object;
        }
        String ddl = this.loadDDL(tableName);
        if (ddl == null) {
            return null;
        }
        DbType schemaDbType = this.schemaDbType;
        if (schemaDbType == null) {
            schemaDbType = this.dbType;
        }
        if ((schemaObject = this.acceptDDL(ddl, schemaDbType)) != null) {
            return schemaObject;
        }
        return this.getDefaultSchema().findTable(tableName);
    }

    public SchemaObject findView(String viewName) {
        SchemaObject object = this.getDefaultSchema().findView(viewName);
        if (object != null) {
            return object;
        }
        String ddl = this.loadDDL(viewName);
        if (ddl == null) {
            return null;
        }
        this.acceptDDL(ddl);
        return this.getDefaultSchema().findView(viewName);
    }

    public SchemaObject findTable(long tableNameHash) {
        return this.getDefaultSchema().findTable(tableNameHash);
    }

    public SchemaObject findTableOrView(String tableName) {
        return this.findTableOrView(tableName, true);
    }

    public SchemaObject findTableOrView(String tableName, boolean onlyCurrent) {
        Schema schema = this.getDefaultSchema();
        SchemaObject object = schema.findTableOrView(tableName);
        if (object != null) {
            return object;
        }
        for (Schema s : this.schemas.values()) {
            if (s == schema || (object = schema.findTableOrView(tableName)) == null) continue;
            return object;
        }
        String ddl = this.loadDDL(tableName);
        if (ddl == null) {
            return null;
        }
        this.acceptDDL(ddl);
        object = schema.findTableOrView(tableName);
        if (object != null) {
            return object;
        }
        for (Schema s : this.schemas.values()) {
            if (s == schema || (object = schema.findTableOrView(tableName)) == null) continue;
            return object;
        }
        return null;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    public SchemaObject findFunction(String functionName) {
        return this.getDefaultSchema().findFunction(functionName);
    }

    public void acceptDDL(String ddl) {
        this.acceptDDL(ddl, this.schemaDbType);
    }

    public SchemaObject acceptDDL(String ddl, DbType dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddl, dbType);
        for (SQLStatement stmt : stmtList) {
            SchemaObject schemaObject;
            if (stmt instanceof SQLCreateTableStatement) {
                schemaObject = this.acceptCreateTable((SQLCreateTableStatement)stmt);
                if (stmtList.size() != 1) continue;
                return schemaObject;
            }
            if (stmt instanceof SQLCreateViewStatement) {
                schemaObject = this.acceptView((SQLCreateViewStatement)stmt);
                if (stmtList.size() != 1) continue;
                return schemaObject;
            }
            this.accept(stmt);
        }
        return null;
    }

    public void accept(SQLStatement stmt) {
        stmt.accept(this.consoleVisitor);
    }

    public boolean isSequence(String name) {
        return this.getDefaultSchema().isSequence(name);
    }

    public SchemaObject findTable(SQLTableSource tableSource, String alias) {
        return this.getDefaultSchema().findTable(tableSource, alias);
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLSelectItem selectItem) {
        return this.getDefaultSchema().findColumn(tableSource, selectItem);
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLExpr expr) {
        return this.getDefaultSchema().findColumn(tableSource, expr);
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLSelectItem selectItem) {
        return this.getDefaultSchema().findTable(tableSource, selectItem);
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLExpr expr) {
        return this.getDefaultSchema().findTable(tableSource, expr);
    }

    public Map<String, SchemaObject> getTables(SQLTableSource x) {
        return this.getDefaultSchema().getTables(x);
    }

    public boolean removeTable(SQLName name) {
        return this.getDefaultSchema().removeObject(name.nameHashCode64());
    }

    public int getTableCount() {
        return this.getDefaultSchema().getTableCount();
    }

    public Collection<SchemaObject> getObjects() {
        return this.getDefaultSchema().getObjects();
    }

    public int getViewCount() {
        return this.getDefaultSchema().getViewCount();
    }

    public void resolve(SQLSelectStatement stmt, SchemaResolveVisitor.Option ... options) {
        if (stmt == null) {
            return;
        }
        SchemaResolveVisitor resolveVisitor = this.createResolveVisitor(options);
        resolveVisitor.visit(stmt);
    }

    public void resolve(SQLSelect select, SchemaResolveVisitor.Option ... options) {
        if (select == null) {
            return;
        }
        SchemaResolveVisitor resolveVisitor = this.createResolveVisitor(options);
        resolveVisitor.visit(select);
    }

    public void resolve(SQLSelectQueryBlock queryBlock, SchemaResolveVisitor.Option ... options) {
        if (queryBlock == null) {
            return;
        }
        SchemaResolveVisitor resolveVisitor = this.createResolveVisitor(options);
        resolveVisitor.visit(queryBlock);
    }

    public void resolve(SQLStatement stmt, SchemaResolveVisitor.Option ... options) {
        if (stmt == null) {
            return;
        }
        SchemaResolveVisitor resolveVisitor = this.createResolveVisitor(options);
        if (stmt instanceof SQLSelectStatement) {
            resolveVisitor.visit((SQLSelectStatement)stmt);
        } else {
            stmt.accept(resolveVisitor);
        }
    }

    private SchemaResolveVisitor createResolveVisitor(SchemaResolveVisitor.Option ... options) {
        SQLASTVisitorAdapter resolveVisitor;
        int optionsValue = SchemaResolveVisitor.Option.of(options);
        switch (this.dbType) {
            case mysql: 
            case mariadb: 
            case tidb: 
            case sqlite: {
                resolveVisitor = new SchemaResolveVisitorFactory.MySqlResolveVisitor(this, optionsValue);
                break;
            }
            case oracle: {
                resolveVisitor = new SchemaResolveVisitorFactory.OracleResolveVisitor(this, optionsValue);
                break;
            }
            case db2: {
                resolveVisitor = new SchemaResolveVisitorFactory.DB2ResolveVisitor(this, optionsValue);
                break;
            }
            case odps: {
                resolveVisitor = new SchemaResolveVisitorFactory.OdpsResolveVisitor(this, optionsValue);
                break;
            }
            case hive: {
                resolveVisitor = new SchemaResolveVisitorFactory.HiveResolveVisitor(this, optionsValue);
                break;
            }
            case postgresql: 
            case edb: {
                resolveVisitor = new SchemaResolveVisitorFactory.PGResolveVisitor(this, optionsValue);
                break;
            }
            case sqlserver: {
                resolveVisitor = new SchemaResolveVisitorFactory.SQLServerResolveVisitor(this, optionsValue);
                break;
            }
            default: {
                resolveVisitor = new SchemaResolveVisitorFactory.SQLResolveVisitor(this, optionsValue);
            }
        }
        return resolveVisitor;
    }

    public String resolve(String input) {
        SchemaResolveVisitor visitor = this.createResolveVisitor(SchemaResolveVisitor.Option.ResolveAllColumn, SchemaResolveVisitor.Option.ResolveIdentifierAlias);
        List<SQLStatement> stmtList = SQLUtils.parseStatements(input, this.dbType);
        for (SQLStatement stmt : stmtList) {
            stmt.accept(visitor);
        }
        return SQLUtils.toSQLString(stmtList, this.dbType);
    }

    public String console(String input) {
        try {
            StringBuffer buf = new StringBuffer();
            List<SQLStatement> stmtList = SQLUtils.parseStatements(input, this.dbType);
            for (SQLStatement stmt : stmtList) {
                Schema schema;
                if (stmt instanceof SQLShowColumnsStatement) {
                    SQLShowColumnsStatement showColumns = (SQLShowColumnsStatement)stmt;
                    SQLName db = showColumns.getDatabase();
                    schema = db == null ? this.getDefaultSchema() : this.findSchema(db.getSimpleName());
                    SQLName table = null;
                    SchemaObject schemaObject = null;
                    if (schema != null) {
                        table = showColumns.getTable();
                        schemaObject = schema.findTable(table.nameHashCode64());
                    }
                    if (schemaObject == null) {
                        buf.append("ERROR 1146 (42S02): Table '" + table + "' doesn't exist\n");
                        continue;
                    }
                    MySqlCreateTableStatement createTableStmt = (MySqlCreateTableStatement)schemaObject.getStatement();
                    createTableStmt.showCoumns(buf);
                    continue;
                }
                if (stmt instanceof SQLShowCreateTableStatement) {
                    SQLShowCreateTableStatement showCreateTableStmt = (SQLShowCreateTableStatement)stmt;
                    SQLName table = showCreateTableStmt.getName();
                    SchemaObject schemaObject = this.findTable(table);
                    if (schemaObject == null) {
                        buf.append("ERROR 1146 (42S02): Table '" + table + "' doesn't exist\n");
                        continue;
                    }
                    MySqlCreateTableStatement createTableStmt = (MySqlCreateTableStatement)schemaObject.getStatement();
                    createTableStmt.output(buf);
                    continue;
                }
                if (stmt instanceof MySqlRenameTableStatement) {
                    MySqlRenameTableStatement renameStmt = (MySqlRenameTableStatement)stmt;
                    for (MySqlRenameTableStatement.Item item : renameStmt.getItems()) {
                        this.renameTable(item.getName(), item.getTo());
                    }
                    continue;
                }
                if (stmt instanceof SQLShowTablesStatement) {
                    SQLShowTablesStatement showTables = (SQLShowTablesStatement)stmt;
                    SQLName database = showTables.getDatabase();
                    schema = database == null ? this.getDefaultSchema() : this.findSchema(database.getSimpleName());
                    if (schema == null) continue;
                    for (String table : schema.showTables()) {
                        buf.append(table);
                        buf.append('\n');
                    }
                    continue;
                }
                stmt.accept(this.consoleVisitor);
            }
            if (buf.length() == 0) {
                return "\n";
            }
            return buf.toString();
        }
        catch (IOException ex) {
            throw new FastsqlException("exeucte command error.", ex);
        }
    }

    public SchemaObject findTable(SQLName name) {
        if (name instanceof SQLIdentifierExpr) {
            return this.findTable(((SQLIdentifierExpr)name).getName());
        }
        if (name instanceof SQLPropertyExpr) {
            SchemaObject table;
            String schema;
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)name;
            SQLExpr owner = propertyExpr.getOwner();
            String catalog = null;
            if (owner instanceof SQLIdentifierExpr) {
                schema = ((SQLIdentifierExpr)owner).getName();
            } else if (owner instanceof SQLPropertyExpr) {
                schema = ((SQLPropertyExpr)owner).getName();
                catalog = ((SQLPropertyExpr)owner).getOwnernName();
            } else {
                return null;
            }
            long tableHashCode64 = propertyExpr.nameHashCode64();
            Schema schemaObj = this.findSchema(schema, false);
            if (schemaObj != null && (table = schemaObj.findTable(tableHashCode64)) != null) {
                return table;
            }
            String ddl = this.loadDDL(catalog, schema, propertyExpr.getName());
            if (ddl == null) {
                schemaObj = this.findSchema(schema, true);
            } else {
                SQLStatement stmt;
                List<SQLStatement> stmtList = SQLUtils.parseStatements(ddl, this.schemaDbType);
                for (SQLStatement stmt2 : stmtList) {
                    this.accept(stmt2);
                }
                if (stmtList.size() == 1 && (stmt = stmtList.get(0)) instanceof SQLCreateTableStatement) {
                    SQLCreateTableStatement createStmt = (SQLCreateTableStatement)stmt;
                    String schemaName = createStmt.getSchema();
                    schemaObj = this.findSchema(schemaName, true);
                }
            }
            if (schemaObj == null) {
                return null;
            }
            return schemaObj.findTable(tableHashCode64);
        }
        return null;
    }

    public SchemaObject findView(SQLName name) {
        if (name instanceof SQLIdentifierExpr) {
            return this.findView(((SQLIdentifierExpr)name).getName());
        }
        if (name instanceof SQLPropertyExpr) {
            SchemaObject table;
            String schema;
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)name;
            SQLExpr owner = propertyExpr.getOwner();
            String catalog = null;
            if (owner instanceof SQLIdentifierExpr) {
                schema = ((SQLIdentifierExpr)owner).getName();
            } else if (owner instanceof SQLPropertyExpr) {
                schema = ((SQLPropertyExpr)owner).getName();
                catalog = ((SQLPropertyExpr)owner).getOwnernName();
            } else {
                return null;
            }
            long tableHashCode64 = propertyExpr.nameHashCode64();
            Schema schemaObj = this.findSchema(schema, false);
            if (schemaObj != null && (table = schemaObj.findView(tableHashCode64)) != null) {
                return table;
            }
            String ddl = this.loadDDL(catalog, schema, propertyExpr.getName());
            if (ddl == null) {
                schemaObj = this.findSchema(schema, true);
            } else {
                SQLStatement stmt;
                List<SQLStatement> stmtList = SQLUtils.parseStatements(ddl, this.schemaDbType);
                for (SQLStatement stmt2 : stmtList) {
                    this.accept(stmt2);
                }
                if (stmtList.size() == 1 && (stmt = stmtList.get(0)) instanceof SQLCreateTableStatement) {
                    SQLCreateTableStatement createStmt = (SQLCreateTableStatement)stmt;
                    String schemaName = createStmt.getSchema();
                    schemaObj = this.findSchema(schemaName, true);
                }
            }
            if (schemaObj == null) {
                return null;
            }
            return schemaObj.findView(tableHashCode64);
        }
        return null;
    }

    private boolean renameTable(SQLName name, SQLName to) {
        Schema schema;
        if (name instanceof SQLPropertyExpr) {
            String schemaName = ((SQLPropertyExpr)name).getOwnernName();
            schema = this.findSchema(schemaName);
        } else {
            schema = this.getDefaultSchema();
        }
        if (schema == null) {
            return false;
        }
        long nameHashCode64 = name.nameHashCode64();
        SchemaObject schemaObject = schema.findTable(nameHashCode64);
        if (schemaObject != null) {
            MySqlCreateTableStatement createTableStmt = (MySqlCreateTableStatement)schemaObject.getStatement();
            if (createTableStmt != null) {
                createTableStmt.setName(to.clone());
                this.acceptCreateTable(createTableStmt);
            }
            schema.objects.remove(nameHashCode64);
        }
        return true;
    }

    public SchemaObject findTable(SQLExprTableSource x) {
        if (x == null) {
            return null;
        }
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLName) {
            return this.findTable((SQLName)expr);
        }
        return null;
    }

    SchemaObject acceptCreateTable(MySqlCreateTableStatement x) {
        SchemaObject table;
        SQLExprTableSource like = x.getLike();
        if (like != null && (table = this.findTable((SQLName)like.getExpr())) != null) {
            MySqlCreateTableStatement stmt = (MySqlCreateTableStatement)table.getStatement();
            MySqlCreateTableStatement stmtCloned = stmt.clone();
            stmtCloned.setName(x.getName().clone());
            this.acceptCreateTable((SQLCreateTableStatement)stmtCloned);
            return table;
        }
        return this.acceptCreateTable((SQLCreateTableStatement)x);
    }

    SchemaObject acceptCreateTable(SQLCreateTableStatement x) {
        SQLExprTableSource like;
        SQLCreateTableStatement x1 = x.clone();
        String schemaName = x1.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SQLSelect select = x1.getSelect();
        if (select != null) {
            select.accept(this.createResolveVisitor(SchemaResolveVisitor.Option.ResolveAllColumn));
            SQLSelectQueryBlock queryBlock = select.getFirstQueryBlock();
            this.resolve(queryBlock, new SchemaResolveVisitor.Option[0]);
            if (queryBlock != null) {
                List<SQLSelectItem> selectList = queryBlock.getSelectList();
                for (SQLSelectItem selectItem : selectList) {
                    SQLColumnDefinition resolvedColumn;
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    if (selectItemExpr instanceof SQLAllColumnExpr || selectItemExpr instanceof SQLPropertyExpr && ((SQLPropertyExpr)selectItemExpr).getName().equals("*")) continue;
                    SQLColumnDefinition column = null;
                    if (selectItemExpr instanceof SQLName && (resolvedColumn = ((SQLName)selectItemExpr).getResolvedColumn()) != null) {
                        column = new SQLColumnDefinition();
                        column.setDataType(selectItem.computeDataType());
                        if (DbType.mysql == this.dbType) {
                            if (resolvedColumn.getDefaultExpr() != null) {
                                column.setDefaultExpr(resolvedColumn.getDefaultExpr().clone());
                            }
                            if (resolvedColumn.getConstraints().size() > 0) {
                                for (SQLColumnConstraint constraint : resolvedColumn.getConstraints()) {
                                    column.addConstraint(constraint.clone());
                                }
                            }
                            if (resolvedColumn.getComment() != null) {
                                column.setComment(resolvedColumn.getComment());
                            }
                        }
                    }
                    if (column == null) {
                        column = new SQLColumnDefinition();
                        column.setDataType(selectItem.computeDataType());
                    }
                    String name = selectItem.computeAlias();
                    column.setName(name);
                    column.setDbType(this.dbType);
                    x1.addColumn(column);
                }
                if (x1.getTableElementList().size() > 0) {
                    x1.setSelect(null);
                }
            }
        }
        if ((like = x1.getLike()) != null) {
            SQLStatement stmt;
            SchemaObject tableObject = null;
            SQLName name = like.getName();
            if (name != null) {
                tableObject = this.findTable(name);
            }
            SQLCreateTableStatement tableStmt = null;
            if (tableObject != null && (stmt = tableObject.getStatement()) instanceof SQLCreateTableStatement) {
                tableStmt = (SQLCreateTableStatement)stmt;
            }
            if (tableStmt != null) {
                SQLName tableName = x1.getName();
                tableStmt.cloneTo(x1);
                x1.setName(tableName);
                x1.setLike((SQLExprTableSource)null);
            }
        }
        x1.setSchema(null);
        String name = x1.computeName();
        SchemaObject table = schema.findTableOrView(name);
        if (table != null) {
            if (x1.isIfNotExists()) {
                return table;
            }
            LOG.info("replaced table '" + name + "'");
        }
        table = new SchemaObject(schema, name, SchemaObjectType.Table, x1);
        schema.objects.put(table.nameHashCode64(), table);
        return table;
    }

    boolean acceptDropTable(SQLDropTableStatement x) {
        for (SQLExprTableSource table : x.getTableSources()) {
            String schemaName = table.getSchema();
            Schema schema = this.findSchema(schemaName, false);
            if (schema == null) continue;
            long nameHashCode64 = table.getName().nameHashCode64();
            schema.objects.remove(nameHashCode64);
        }
        return true;
    }

    SchemaObject acceptView(SQLCreateViewStatement x) {
        String name;
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SchemaObject view = schema.findTableOrView(name = x.computeName());
        if (view != null) {
            return view;
        }
        SchemaObject object = new SchemaObject(schema, name, SchemaObjectType.View, x.clone());
        long nameHashCode64 = FnvHash.hashCode64(name);
        schema.objects.put(nameHashCode64, object);
        return object;
    }

    boolean acceptView(SQLAlterViewStatement x) {
        String name;
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SchemaObject view = schema.findTableOrView(name = x.computeName());
        if (view != null) {
            return false;
        }
        SchemaObject object = new SchemaObject(schema, name, SchemaObjectType.View, x.clone());
        schema.objects.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptDropIndex(SQLDropIndexStatement x) {
        SQLCreateTableStatement stmt;
        if (x.getTableName() == null) {
            return false;
        }
        SQLName table = x.getTableName().getName();
        SchemaObject object = this.findTable(table);
        if (object != null && (stmt = (SQLCreateTableStatement)object.getStatement()) != null) {
            stmt.apply(x);
            return true;
        }
        return false;
    }

    boolean acceptCreateIndex(SQLCreateIndexStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        String name = x.getName().getSimpleName();
        SchemaObject object = new SchemaObject(schema, name, SchemaObjectType.Index, x.clone());
        schema.objects.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptCreateFunction(SQLCreateFunctionStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        String name = x.getName().getSimpleName();
        SchemaObject object = new SchemaObject(schema, name, SchemaObjectType.Function, x.clone());
        schema.functions.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptAlterTable(SQLAlterTableStatement x) {
        SQLCreateTableStatement stmt;
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SchemaObject object = schema.findTable(x.nameHashCode64());
        if (object != null && (stmt = (SQLCreateTableStatement)object.getStatement()) != null) {
            stmt.apply(x);
            return true;
        }
        return false;
    }

    public boolean acceptCreateSequence(SQLCreateSequenceStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        String name = x.getName().getSimpleName();
        SchemaObject object = new SchemaObject(schema, name, SchemaObjectType.Sequence);
        schema.objects.put(object.nameHashCode64(), object);
        return false;
    }

    public boolean acceptDropSequence(SQLDropSequenceStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        long nameHashCode64 = x.getName().nameHashCode64();
        schema.objects.remove(nameHashCode64);
        return false;
    }

    public SQLDataType findFuntionReturnType(long functionNameHashCode) {
        if (functionNameHashCode == FnvHash.Constants.LEN || functionNameHashCode == FnvHash.Constants.LENGTH) {
            return SQLIntegerExpr.DATA_TYPE;
        }
        return null;
    }

    protected String loadDDL(String table) {
        if (table == null) {
            return null;
        }
        table = SQLUtils.normalize(table, this.schemaDbType);
        if (this.schemaLoader != null) {
            return this.schemaLoader.loadDDL(null, null, table);
        }
        return null;
    }

    protected String loadDDL(String schema, String table) {
        if (table == null) {
            return null;
        }
        table = SQLUtils.normalize(table, this.dbType);
        if (schema != null) {
            schema = SQLUtils.normalize(schema, this.dbType);
        }
        if (this.schemaLoader != null) {
            return this.schemaLoader.loadDDL(null, schema, table);
        }
        return null;
    }

    protected String loadDDL(String catalog, String schema, String table) {
        if (table == null) {
            return null;
        }
        table = SQLUtils.normalize(table, this.dbType);
        if (schema != null) {
            schema = SQLUtils.normalize(schema, this.dbType);
        }
        if (catalog != null) {
            catalog = SQLUtils.normalize(catalog, this.dbType);
        }
        if (this.schemaLoader != null) {
            return this.schemaLoader.loadDDL(catalog, schema, table);
        }
        return null;
    }

    public SchemaLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    public void setSchemaLoader(SchemaLoader schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    public static interface SchemaLoader {
        public String loadDDL(String var1, String var2, String var3);
    }

    public class DefaultConsoleSchemaVisitor
    extends SQLASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            SchemaRepository.this.acceptDropSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            SchemaRepository.this.acceptCreateSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(HiveCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropTableStatement x) {
            SchemaRepository.this.acceptDropTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            SchemaRepository.this.acceptCreateIndex(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaRepository.this.acceptCreateFunction(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaRepository.this.acceptAlterTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropIndexStatement x) {
            SchemaRepository.this.acceptDropIndex(x);
            return false;
        }
    }

    public class OracleConsoleSchemaVisitor
    extends OracleASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            SchemaRepository.this.acceptDropSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            SchemaRepository.this.acceptCreateSequence(x);
            return false;
        }

        @Override
        public boolean visit(OracleCreateTableStatement x) {
            this.visit((SQLCreateTableStatement)x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropTableStatement x) {
            SchemaRepository.this.acceptDropTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            SchemaRepository.this.acceptCreateIndex(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaRepository.this.acceptCreateFunction(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaRepository.this.acceptAlterTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLUseStatement x) {
            String schema = x.getDatabase().getSimpleName();
            SchemaRepository.this.setDefaultSchema(schema);
            return false;
        }

        @Override
        public boolean visit(SQLDropIndexStatement x) {
            SchemaRepository.this.acceptDropIndex(x);
            return false;
        }
    }

    public class MySqlConsoleSchemaVisitor
    extends MySqlASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            SchemaRepository.this.acceptDropSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            SchemaRepository.this.acceptCreateSequence(x);
            return false;
        }

        @Override
        public boolean visit(HiveCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(MySqlCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropTableStatement x) {
            SchemaRepository.this.acceptDropTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            SchemaRepository.this.acceptCreateIndex(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaRepository.this.acceptCreateFunction(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaRepository.this.acceptAlterTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLUseStatement x) {
            String schema = x.getDatabase().getSimpleName();
            SchemaRepository.this.setDefaultSchema(schema);
            return false;
        }

        @Override
        public boolean visit(SQLDropIndexStatement x) {
            SchemaRepository.this.acceptDropIndex(x);
            return false;
        }
    }
}

