/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.metadata.holder.xlsx;

import com.alibaba.excel.constant.BuiltinFormats;
import com.alibaba.excel.metadata.data.DataFormatData;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.read.metadata.holder.ReadWorkbookHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.MapUtils;
import java.util.Map;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class XlsxReadWorkbookHolder
extends ReadWorkbookHolder {
    private OPCPackage opcPackage;
    private String saxParserFactoryName;
    private StylesTable stylesTable;
    private Map<Integer, DataFormatData> dataFormatDataCache;

    public XlsxReadWorkbookHolder(ReadWorkbook readWorkbook) {
        super(readWorkbook);
        this.saxParserFactoryName = readWorkbook.getXlsxSAXParserFactoryName();
        this.setExcelType(ExcelTypeEnum.XLSX);
        this.dataFormatDataCache = MapUtils.newHashMap();
    }

    public DataFormatData dataFormatData(int dateFormatIndexInteger) {
        return this.dataFormatDataCache.computeIfAbsent(dateFormatIndexInteger, key -> {
            DataFormatData dataFormatData = new DataFormatData();
            if (this.stylesTable == null) {
                return null;
            }
            XSSFCellStyle xssfCellStyle = this.stylesTable.getStyleAt(dateFormatIndexInteger);
            dataFormatData.setIndex(xssfCellStyle.getDataFormat());
            dataFormatData.setFormat(BuiltinFormats.getBuiltinFormat(dataFormatData.getIndex(), xssfCellStyle.getDataFormatString(), this.globalConfiguration().getLocale()));
            return dataFormatData;
        });
    }

    public OPCPackage getOpcPackage() {
        return this.opcPackage;
    }

    public String getSaxParserFactoryName() {
        return this.saxParserFactoryName;
    }

    public StylesTable getStylesTable() {
        return this.stylesTable;
    }

    public Map<Integer, DataFormatData> getDataFormatDataCache() {
        return this.dataFormatDataCache;
    }

    public void setOpcPackage(OPCPackage opcPackage) {
        this.opcPackage = opcPackage;
    }

    public void setSaxParserFactoryName(String saxParserFactoryName) {
        this.saxParserFactoryName = saxParserFactoryName;
    }

    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    public void setDataFormatDataCache(Map<Integer, DataFormatData> dataFormatDataCache) {
        this.dataFormatDataCache = dataFormatDataCache;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XlsxReadWorkbookHolder)) {
            return false;
        }
        XlsxReadWorkbookHolder other = (XlsxReadWorkbookHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OPCPackage this$opcPackage = this.getOpcPackage();
        OPCPackage other$opcPackage = other.getOpcPackage();
        if (this$opcPackage == null ? other$opcPackage != null : !this$opcPackage.equals(other$opcPackage)) {
            return false;
        }
        String this$saxParserFactoryName = this.getSaxParserFactoryName();
        String other$saxParserFactoryName = other.getSaxParserFactoryName();
        if (this$saxParserFactoryName == null ? other$saxParserFactoryName != null : !this$saxParserFactoryName.equals(other$saxParserFactoryName)) {
            return false;
        }
        StylesTable this$stylesTable = this.getStylesTable();
        StylesTable other$stylesTable = other.getStylesTable();
        if (this$stylesTable == null ? other$stylesTable != null : !this$stylesTable.equals(other$stylesTable)) {
            return false;
        }
        Map<Integer, DataFormatData> this$dataFormatDataCache = this.getDataFormatDataCache();
        Map<Integer, DataFormatData> other$dataFormatDataCache = other.getDataFormatDataCache();
        return !(this$dataFormatDataCache == null ? other$dataFormatDataCache != null : !((Object)this$dataFormatDataCache).equals(other$dataFormatDataCache));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XlsxReadWorkbookHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OPCPackage $opcPackage = this.getOpcPackage();
        result = result * 59 + ($opcPackage == null ? 43 : $opcPackage.hashCode());
        String $saxParserFactoryName = this.getSaxParserFactoryName();
        result = result * 59 + ($saxParserFactoryName == null ? 43 : $saxParserFactoryName.hashCode());
        StylesTable $stylesTable = this.getStylesTable();
        result = result * 59 + ($stylesTable == null ? 43 : $stylesTable.hashCode());
        Map<Integer, DataFormatData> $dataFormatDataCache = this.getDataFormatDataCache();
        result = result * 59 + ($dataFormatDataCache == null ? 43 : ((Object)$dataFormatDataCache).hashCode());
        return result;
    }
}

