/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.util.MapUtils;
import com.alibaba.excel.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class DateUtils {
    private static final ThreadLocal<Map<Short, Boolean>> DATE_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<Map<String, SimpleDateFormat>> DATE_FORMAT_THREAD_LOCAL = new ThreadLocal();
    private static final Pattern date_ptrn1 = Pattern.compile("^\\[\\$\\-.*?\\]");
    private static final Pattern date_ptrn2 = Pattern.compile("^\\[[a-zA-Z]+\\]");
    private static final Pattern date_ptrn3a = Pattern.compile("[yYmMdDhHsS]");
    private static final Pattern date_ptrn3b = Pattern.compile("^[\\[\\]yYmMdDhHsS\\-T/\u5e74\u6708\u65e5,. :\"\\\\]+0*[ampAMP/]*$");
    private static final Pattern date_ptrn4 = Pattern.compile("^\\[([hH]+|[mM]+|[sS]+)\\]");
    private static final Pattern date_ptrn5 = Pattern.compile("^\\[DBNum(1|2|3)\\]");
    private static final Pattern date_ptrn6 = Pattern.compile("(\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2)+");
    public static final String DATE_FORMAT_10 = "yyyy-MM-dd";
    public static final String DATE_FORMAT_14 = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_16 = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_16_FORWARD_SLASH = "yyyy/MM/dd HH:mm";
    public static final String DATE_FORMAT_17 = "yyyyMMdd HH:mm:ss";
    public static final String DATE_FORMAT_19 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_19_FORWARD_SLASH = "yyyy/MM/dd HH:mm:ss";
    private static final String MINUS = "-";
    public static String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";

    private DateUtils() {
    }

    public static Date parseDate(String dateString, String dateFormat) throws ParseException {
        if (StringUtils.isEmpty(dateFormat)) {
            dateFormat = DateUtils.switchDateFormat(dateString);
        }
        return DateUtils.getCacheDateFormat(dateFormat).parse(dateString);
    }

    public static LocalDateTime parseLocalDateTime(String dateString, String dateFormat, Locale local) {
        if (StringUtils.isEmpty(dateFormat)) {
            dateFormat = DateUtils.switchDateFormat(dateString);
        }
        if (local == null) {
            return LocalDateTime.parse(dateString, DateTimeFormatter.ofPattern(dateFormat));
        }
        return LocalDateTime.parse(dateString, DateTimeFormatter.ofPattern(dateFormat, local));
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DateUtils.parseDate(dateString, DateUtils.switchDateFormat(dateString));
    }

    public static String switchDateFormat(String dateString) {
        int length = dateString.length();
        switch (length) {
            case 19: {
                if (dateString.contains(MINUS)) {
                    return DATE_FORMAT_19;
                }
                return DATE_FORMAT_19_FORWARD_SLASH;
            }
            case 16: {
                if (dateString.contains(MINUS)) {
                    return DATE_FORMAT_16;
                }
                return DATE_FORMAT_16_FORWARD_SLASH;
            }
            case 17: {
                return DATE_FORMAT_17;
            }
            case 14: {
                return DATE_FORMAT_14;
            }
            case 10: {
                return DATE_FORMAT_10;
            }
        }
        throw new IllegalArgumentException("can not find date format for\uff1a" + dateString);
    }

    public static String format(Date date) {
        return DateUtils.format(date, null);
    }

    public static String format(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty(dateFormat)) {
            dateFormat = defaultDateFormat;
        }
        return DateUtils.getCacheDateFormat(dateFormat).format(date);
    }

    public static String format(LocalDateTime date, String dateFormat, Locale local) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty(dateFormat)) {
            dateFormat = defaultDateFormat;
        }
        if (local == null) {
            return date.format(DateTimeFormatter.ofPattern(dateFormat));
        }
        return date.format(DateTimeFormatter.ofPattern(dateFormat, local));
    }

    private static DateFormat getCacheDateFormat(String dateFormat) {
        Map<String, SimpleDateFormat> dateFormatMap = DATE_FORMAT_THREAD_LOCAL.get();
        if (dateFormatMap == null) {
            dateFormatMap = new HashMap<String, SimpleDateFormat>();
            DATE_FORMAT_THREAD_LOCAL.set(dateFormatMap);
        } else {
            SimpleDateFormat dateFormatCached = dateFormatMap.get(dateFormat);
            if (dateFormatCached != null) {
                return dateFormatCached;
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        dateFormatMap.put(dateFormat, simpleDateFormat);
        return simpleDateFormat;
    }

    public static boolean isADateFormat(Short formatIndex, String formatString) {
        if (formatIndex == null) {
            return false;
        }
        Map<Short, Boolean> isDateCache = DATE_THREAD_LOCAL.get();
        if (isDateCache == null) {
            isDateCache = MapUtils.newHashMap();
            DATE_THREAD_LOCAL.set(isDateCache);
        } else {
            Boolean isDateCachedData = isDateCache.get(formatIndex);
            if (isDateCachedData != null) {
                return isDateCachedData;
            }
        }
        boolean isDate = DateUtils.isADateFormatUncached(formatIndex, formatString);
        isDateCache.put(formatIndex, isDate);
        return isDate;
    }

    public static boolean isADateFormatUncached(Short formatIndex, String formatString) {
        if (DateUtils.isInternalDateFormat(formatIndex)) {
            return true;
        }
        if (StringUtils.isEmpty(formatString)) {
            return false;
        }
        String fs = formatString;
        int length = fs.length();
        StringBuilder sb = new StringBuilder(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = fs.charAt(i);
            if (i < length - 1) {
                char nc = fs.charAt(i + 1);
                if (c == '\\') {
                    switch (nc) {
                        case ' ': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '\\': {
                            continue block3;
                        }
                    }
                } else if (c == ';' && nc == '@') {
                    ++i;
                    continue;
                }
            }
            sb.append(c);
        }
        fs = sb.toString();
        if (date_ptrn4.matcher(fs).matches()) {
            return true;
        }
        fs = date_ptrn5.matcher(fs).replaceAll("");
        fs = date_ptrn1.matcher(fs).replaceAll("");
        int separatorIndex = (fs = date_ptrn2.matcher(fs).replaceAll("")).indexOf(59);
        if (0 < separatorIndex && separatorIndex < fs.length() - 1) {
            fs = fs.substring(0, separatorIndex);
        }
        if (!date_ptrn3a.matcher(fs).find()) {
            return false;
        }
        boolean result = date_ptrn3b.matcher(fs).matches();
        if (result) {
            return true;
        }
        result = date_ptrn6.matcher(fs).find();
        return result;
    }

    public static boolean isInternalDateFormat(short format) {
        switch (format) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public static void removeThreadLocalCache() {
        DATE_THREAD_LOCAL.remove();
        DATE_FORMAT_THREAD_LOCAL.remove();
    }
}

