/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONPOJOBuilder;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanInfo {
    public final Class<?> clazz;
    public final Class<?> builderClass;
    public final Constructor<?> defaultConstructor;
    public final Constructor<?> creatorConstructor;
    public final Method factoryMethod;
    public final Method buildMethod;
    public final int defaultConstructorParameterSize;
    public final FieldInfo[] fields;
    public final FieldInfo[] sortedFields;
    public final int parserFeatures;
    public final JSONType jsonType;
    public final String typeName;
    public final String typeKey;
    public String[] orders;

    public JavaBeanInfo(Class<?> clazz, Class<?> builderClass, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, Method buildMethod, JSONType jsonType, List<FieldInfo> fieldList) {
        this.clazz = clazz;
        this.builderClass = builderClass;
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.parserFeatures = TypeUtils.getParserFeatures(clazz);
        this.buildMethod = buildMethod;
        this.jsonType = jsonType;
        if (jsonType != null) {
            String typeName = jsonType.typeName();
            String typeKey = jsonType.typeKey();
            this.typeKey = typeKey.length() > 0 ? typeKey : null;
            this.typeName = typeName.length() != 0 ? typeName : clazz.getName();
            Object[] orders = jsonType.orders();
            this.orders = orders.length == 0 ? null : orders;
        } else {
            this.typeName = clazz.getName();
            this.typeKey = null;
            this.orders = null;
        }
        this.fields = new FieldInfo[fieldList.size()];
        fieldList.toArray(this.fields);
        Object[] sortedFields = new FieldInfo[this.fields.length];
        if (this.orders != null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(fieldList.size());
            for (FieldInfo field : this.fields) {
                map.put(field.name, field);
            }
            int i = 0;
            for (String item : this.orders) {
                FieldInfo field = (FieldInfo)map.get(item);
                if (field == null) continue;
                sortedFields[i++] = field;
                map.remove(item);
            }
            for (FieldInfo field : map.values()) {
                sortedFields[i++] = field;
            }
        } else {
            System.arraycopy(this.fields, 0, sortedFields, 0, this.fields.length);
            Arrays.sort(sortedFields);
        }
        if (Arrays.equals(this.fields, sortedFields)) {
            sortedFields = this.fields;
        }
        this.sortedFields = sortedFields;
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : (factoryMethod != null ? factoryMethod.getParameterTypes().length : 0);
    }

    private static FieldInfo getField(List<FieldInfo> fieldList, String propertyName) {
        for (FieldInfo item : fieldList) {
            if (item.name.equals(propertyName)) {
                return item;
            }
            Field field = item.field;
            if (field == null || item.getAnnotation() == null || !field.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    static boolean add(List<FieldInfo> fieldList, FieldInfo field) {
        for (int i = fieldList.size() - 1; i >= 0; --i) {
            FieldInfo item = fieldList.get(i);
            if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
            if (item.fieldClass.isAssignableFrom(field.fieldClass)) {
                fieldList.remove(i);
                break;
            }
            int result = item.compareTo(field);
            if (result < 0) {
                fieldList.remove(i);
                break;
            }
            return false;
        }
        fieldList.add(field);
        return true;
    }

    public static JavaBeanInfo build(Class<?> clazz, Type type, PropertyNamingStrategy propertyNamingStrategy) {
        return JavaBeanInfo.build(clazz, type, propertyNamingStrategy, false, TypeUtils.compatibleWithJavaBean);
    }

    public static JavaBeanInfo build(Class<?> clazz, Type type, PropertyNamingStrategy propertyNamingStrategy, boolean fieldBased, boolean compatibleWithJavaBean) {
        boolean isInterfaceOrAbstract;
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        Class<?> builderClass = JavaBeanInfo.getBuilderClass(jsonType);
        Field[] declaredFields = clazz.getDeclaredFields();
        Method[] methods = clazz.getMethods();
        Constructor[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> defaultConstructor = builderClass == null ? JavaBeanInfo.getDefaultConstructor(clazz, constructors) : JavaBeanInfo.getDefaultConstructor(builderClass, builderClass.getDeclaredConstructors());
        Constructor creatorConstructor = null;
        Method buildMethod = null;
        Method factoryMethod = null;
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        if (fieldBased) {
            for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] fields = currentClass.getDeclaredFields();
                JavaBeanInfo.computeFields(clazz, type, propertyNamingStrategy, fieldList, fields);
            }
            return new JavaBeanInfo(clazz, builderClass, defaultConstructor, null, factoryMethod, buildMethod, jsonType, fieldList);
        }
        boolean bl = isInterfaceOrAbstract = clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers());
        if (defaultConstructor == null || isInterfaceOrAbstract) {
            creatorConstructor = JavaBeanInfo.getCreatorConstructor(constructors);
            if (creatorConstructor != null && !isInterfaceOrAbstract) {
                TypeUtils.setAccessible(creatorConstructor);
                Class<?>[] types = creatorConstructor.getParameterTypes();
                if (types.length > 0) {
                    Annotation[][] paramAnnotationArrays = creatorConstructor.getParameterAnnotations();
                    for (int i = 0; i < types.length; ++i) {
                        Annotation[] paramAnnotations = paramAnnotationArrays[i];
                        JSONField fieldAnnotation = null;
                        for (Annotation paramAnnotation : paramAnnotations) {
                            if (!(paramAnnotation instanceof JSONField)) continue;
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        if (fieldAnnotation == null) {
                            throw new JSONException("illegal json creator");
                        }
                        Class<?> clazz2 = types[i];
                        Type fieldType = creatorConstructor.getGenericParameterTypes()[i];
                        Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                        int ordinal = fieldAnnotation.ordinal();
                        int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        int parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                        FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, clazz2, fieldType, field, ordinal, serialzeFeatures, parserFeatures);
                        JavaBeanInfo.add(fieldList, fieldInfo);
                    }
                }
                return new JavaBeanInfo(clazz, builderClass, null, creatorConstructor, null, null, jsonType, fieldList);
            }
            factoryMethod = JavaBeanInfo.getFactoryMethod(clazz, methods);
            if (factoryMethod != null) {
                TypeUtils.setAccessible(factoryMethod);
                Class<?>[] types = factoryMethod.getParameterTypes();
                if (types.length > 0) {
                    Annotation[][] paramAnnotationArrays = factoryMethod.getParameterAnnotations();
                    for (int i = 0; i < types.length; ++i) {
                        Annotation[] paramAnnotations = paramAnnotationArrays[i];
                        JSONField fieldAnnotation = null;
                        for (Annotation paramAnnotation : paramAnnotations) {
                            if (!(paramAnnotation instanceof JSONField)) continue;
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        if (fieldAnnotation == null) {
                            throw new JSONException("illegal json creator");
                        }
                        Class<?> clazz3 = types[i];
                        Type fieldType = factoryMethod.getGenericParameterTypes()[i];
                        Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                        int ordinal = fieldAnnotation.ordinal();
                        int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        int parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                        FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, clazz3, fieldType, field, ordinal, serialzeFeatures, parserFeatures);
                        JavaBeanInfo.add(fieldList, fieldInfo);
                    }
                    return new JavaBeanInfo(clazz, builderClass, null, null, factoryMethod, null, jsonType, fieldList);
                }
            } else if (!isInterfaceOrAbstract) {
                String[] paramNames = null;
                boolean kotlin = TypeUtils.isKotlin(clazz);
                if (kotlin && constructors.length > 0) {
                    paramNames = TypeUtils.getKoltinConstructorParameters(clazz);
                    creatorConstructor = constructors[constructors.length - 1];
                    TypeUtils.setAccessible(creatorConstructor);
                } else {
                    for (Constructor constructor : constructors) {
                        boolean is_public;
                        boolean bl2 = is_public = (constructor.getModifiers() & 1) != 0;
                        if (!is_public) continue;
                        paramNames = ASMUtils.lookupParameterNames(constructor);
                        if (paramNames != null && paramNames.length != 0) {
                            creatorConstructor = constructor;
                            break;
                        }
                        paramNames = null;
                    }
                }
                Class<?>[] types = null;
                if (paramNames != null) {
                    types = creatorConstructor.getParameterTypes();
                }
                if (paramNames != null && types.length == paramNames.length) {
                    Annotation[][] paramAnnotationArrays = creatorConstructor.getParameterAnnotations();
                    for (int i = 0; i < types.length; ++i) {
                        int parserFeatures;
                        int serialzeFeatures;
                        int ordinal;
                        Annotation[] annotationArray = paramAnnotationArrays[i];
                        String paramName = paramNames[i];
                        JSONField fieldAnnotation = null;
                        for (Annotation paramAnnotation : annotationArray) {
                            if (!(paramAnnotation instanceof JSONField)) continue;
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        Class<?> fieldClass = types[i];
                        Type fieldType = creatorConstructor.getGenericParameterTypes()[i];
                        Field field = TypeUtils.getField(clazz, paramName, declaredFields);
                        if (field != null && fieldAnnotation == null) {
                            fieldAnnotation = field.getAnnotation(JSONField.class);
                        }
                        if (fieldAnnotation == null) {
                            ordinal = 0;
                            serialzeFeatures = 0;
                            parserFeatures = 0;
                        } else {
                            String nameAnnotated = fieldAnnotation.name();
                            if (nameAnnotated.length() != 0) {
                                paramName = nameAnnotated;
                            }
                            ordinal = fieldAnnotation.ordinal();
                            serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                            parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                        }
                        FieldInfo fieldInfo = new FieldInfo(paramName, clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures, parserFeatures);
                        JavaBeanInfo.add(fieldList, fieldInfo);
                    }
                    return new JavaBeanInfo(clazz, builderClass, null, creatorConstructor, null, null, jsonType, fieldList);
                }
                throw new JSONException("default constructor not found. " + clazz);
            }
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(defaultConstructor);
        }
        if (builderClass != null) {
            Object withPrefix = null;
            JSONPOJOBuilder builderAnno = builderClass.getAnnotation(JSONPOJOBuilder.class);
            if (builderAnno != null) {
                withPrefix = builderAnno.withPrefix();
            }
            if (withPrefix == null || ((String)withPrefix).length() == 0) {
                withPrefix = "with";
            }
            for (Method method : builderClass.getMethods()) {
                char c0;
                String methodName;
                if (Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(builderClass)) continue;
                int ordinal = 0;
                int serialzeFeatures = 0;
                int parserFeatures = 0;
                JSONField annotation = method.getAnnotation(JSONField.class);
                if (annotation == null) {
                    annotation = TypeUtils.getSuperMethodAnnotation(clazz, method);
                }
                if (annotation != null) {
                    if (!annotation.deserialize()) continue;
                    ordinal = annotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                    parserFeatures = Feature.of(annotation.parseFeatures());
                    if (annotation.name().length() != 0) {
                        String propertyName = annotation.name();
                        JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures, parserFeatures, annotation, null, null));
                        continue;
                    }
                }
                if (!(methodName = method.getName()).startsWith((String)withPrefix) || methodName.length() <= ((String)withPrefix).length() || !Character.isUpperCase(c0 = methodName.charAt(((String)withPrefix).length()))) continue;
                StringBuilder properNameBuilder = new StringBuilder(methodName.substring(((String)withPrefix).length()));
                properNameBuilder.setCharAt(0, Character.toLowerCase(c0));
                String propertyName = properNameBuilder.toString();
                JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures, parserFeatures, annotation, null, null));
            }
            if (builderClass != null) {
                JSONPOJOBuilder builderAnnotation = builderClass.getAnnotation(JSONPOJOBuilder.class);
                String buildMethodName = null;
                if (builderAnnotation != null) {
                    buildMethodName = builderAnnotation.buildMethod();
                }
                if (buildMethodName == null || buildMethodName.length() == 0) {
                    buildMethodName = "build";
                }
                try {
                    buildMethod = builderClass.getMethod(buildMethodName, new Class[0]);
                }
                catch (NoSuchMethodException i) {
                }
                catch (SecurityException i) {
                    // empty catch block
                }
                if (buildMethod == null) {
                    try {
                        buildMethod = builderClass.getMethod("create", new Class[0]);
                    }
                    catch (NoSuchMethodException i) {
                    }
                    catch (SecurityException i) {
                        // empty catch block
                    }
                }
                if (buildMethod == null) {
                    throw new JSONException("buildMethod not found.");
                }
                TypeUtils.setAccessible(buildMethod);
            }
        }
        for (Method method : methods) {
            String propertyName;
            Class<?>[] types;
            Class<?> returnType;
            int ordinal = 0;
            int n = 0;
            int parserFeatures = 0;
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || !(returnType = method.getReturnType()).equals(Void.TYPE) && !returnType.equals(method.getDeclaringClass()) || method.getDeclaringClass() == Object.class || (types = method.getParameterTypes()).length == 0 || types.length > 2) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null && types.length == 2 && types[0] == String.class && types[1] == Object.class) {
                JavaBeanInfo.add(fieldList, new FieldInfo("", method, null, clazz, type, ordinal, n, parserFeatures, annotation, null, null));
                continue;
            }
            if (types.length != 1) continue;
            if (annotation == null) {
                annotation = TypeUtils.getSuperMethodAnnotation(clazz, method);
            }
            if (annotation == null && methodName.length() < 4) continue;
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                ordinal = annotation.ordinal();
                n = SerializerFeature.of(annotation.serialzeFeatures());
                parserFeatures = Feature.of(annotation.parseFeatures());
                if (annotation.name().length() != 0) {
                    String propertyName2 = annotation.name();
                    JavaBeanInfo.add(fieldList, new FieldInfo(propertyName2, method, null, clazz, type, ordinal, n, parserFeatures, annotation, null, null));
                    continue;
                }
            }
            if (annotation == null && !methodName.startsWith("set")) continue;
            char c3 = methodName.charAt(3);
            if (Character.isUpperCase(c3) || c3 > '\u0200') {
                propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            } else if (c3 == '_') {
                propertyName = methodName.substring(4);
            } else if (c3 == 'f') {
                propertyName = methodName.substring(3);
            } else {
                if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                propertyName = TypeUtils.decapitalize(methodName.substring(3));
            }
            Field field = TypeUtils.getField(clazz, propertyName, declaredFields);
            if (field == null && types[0] == Boolean.TYPE) {
                String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                field = TypeUtils.getField(clazz, isFieldName, declaredFields);
            }
            JSONField fieldAnnotation = null;
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null) {
                if (!fieldAnnotation.deserialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                n = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, method, field, clazz, type, ordinal, n, parserFeatures, annotation, fieldAnnotation, null));
                    continue;
                }
            }
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, method, field, clazz, type, ordinal, n, parserFeatures, annotation, fieldAnnotation, null));
        }
        Field[] fields = clazz.getFields();
        JavaBeanInfo.computeFields(clazz, type, propertyNamingStrategy, fieldList, fields);
        for (Method method : clazz.getMethods()) {
            String propertyName;
            JSONField annotation;
            String string = method.getName();
            if (string.length() < 4 || Modifier.isStatic(method.getModifiers()) || !string.startsWith("get") || !Character.isUpperCase(string.charAt(3)) || method.getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(method.getReturnType()) && !Map.class.isAssignableFrom(method.getReturnType()) && AtomicBoolean.class != method.getReturnType() && AtomicInteger.class != method.getReturnType() && AtomicLong.class != method.getReturnType() || (annotation = method.getAnnotation(JSONField.class)) != null && annotation.deserialize()) continue;
            if (annotation != null && annotation.name().length() > 0) {
                propertyName = annotation.name();
            } else {
                JSONField fieldAnnotation;
                propertyName = Character.toLowerCase(string.charAt(3)) + string.substring(4);
                Field field = TypeUtils.getField(clazz, propertyName, declaredFields);
                if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && !fieldAnnotation.deserialize()) continue;
            }
            FieldInfo fieldInfo = JavaBeanInfo.getField(fieldList, propertyName);
            if (fieldInfo != null) continue;
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, method, null, clazz, type, 0, 0, 0, annotation, null, null));
        }
        return new JavaBeanInfo(clazz, builderClass, defaultConstructor, null, factoryMethod, buildMethod, jsonType, fieldList);
    }

    private static void computeFields(Class<?> clazz, Type type, PropertyNamingStrategy propertyNamingStrategy, List<FieldInfo> fieldList, Field[] fields) {
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if ((modifiers & 8) != 0) continue;
            if ((modifiers & 0x10) != 0) {
                boolean supportReadOnly;
                Class<?> fieldType = field.getType();
                boolean bl = supportReadOnly = Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType) || AtomicLong.class.equals(fieldType) || AtomicInteger.class.equals(fieldType) || AtomicBoolean.class.equals(fieldType);
                if (!supportReadOnly) continue;
            }
            boolean contains = false;
            for (FieldInfo item : fieldList) {
                if (!item.name.equals(field.getName())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            int parserFeatures = 0;
            String propertyName = field.getName();
            JSONField fieldAnnotation = field.getAnnotation(JSONField.class);
            if (fieldAnnotation != null) {
                if (!fieldAnnotation.deserialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, null, field, clazz, type, ordinal, serialzeFeatures, parserFeatures, null, fieldAnnotation, null));
        }
    }

    static Constructor<?> getDefaultConstructor(Class<?> clazz, Constructor<?>[] constructors) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            for (Constructor<?> constructor : constructors) {
                Class<?>[] types = constructor.getParameterTypes();
                if (types.length != 1 || !types[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }

    public static Constructor<?> getCreatorConstructor(Constructor[] constructors) {
        Constructor creatorConstructor = null;
        for (Constructor constructor : constructors) {
            JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
            if (annotation == null) continue;
            if (creatorConstructor != null) {
                throw new JSONException("multi-JSONCreator");
            }
            creatorConstructor = constructor;
        }
        if (creatorConstructor != null) {
            return creatorConstructor;
        }
        for (Constructor constructor : constructors) {
            Annotation[][] paramAnnotationArrays = constructor.getParameterAnnotations();
            if (paramAnnotationArrays.length == 0) continue;
            boolean match = true;
            for (Annotation[] paramAnnotationArray : paramAnnotationArrays) {
                boolean paramMatch = false;
                for (Annotation paramAnnotation : paramAnnotationArray) {
                    if (!(paramAnnotation instanceof JSONField)) continue;
                    paramMatch = true;
                    break;
                }
                if (paramMatch) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (creatorConstructor != null) {
                throw new JSONException("multi-JSONCreator");
            }
            creatorConstructor = constructor;
        }
        if (creatorConstructor != null) {
            return creatorConstructor;
        }
        return creatorConstructor;
    }

    private static Method getFactoryMethod(Class<?> clazz, Method[] methods) {
        Method factoryMethod = null;
        for (Method method : methods) {
            JSONCreator annotation;
            if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType()) || (annotation = method.getAnnotation(JSONCreator.class)) == null) continue;
            if (factoryMethod != null) {
                throw new JSONException("multi-JSONCreator");
            }
            factoryMethod = method;
        }
        return factoryMethod;
    }

    public static Class<?> getBuilderClass(JSONType type) {
        if (type == null) {
            return null;
        }
        Class<?> builderClass = type.builder();
        if (builderClass == Void.class) {
            return null;
        }
        return builderClass;
    }
}

