/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.client.config.impl.AbstractConfigChangeParser;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YmlChangeParser
extends AbstractConfigChangeParser {
    private static final String INVALID_CONSTRUCTOR_ERROR_INFO = "could not determine a constructor for the tag";

    public YmlChangeParser() {
        super("yaml");
    }

    public Map<String, ConfigChangeItem> doParse(String oldContent, String newContent, String type) {
        Map<String, Object> oldMap = Collections.emptyMap();
        Map<String, Object> newMap = Collections.emptyMap();
        try {
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
            if (StringUtils.isNotBlank((String)oldContent)) {
                oldMap = (Map<String, Object>)yaml.load(oldContent);
                oldMap = this.getFlattenedMap(oldMap);
            }
            if (StringUtils.isNotBlank((String)newContent)) {
                newMap = (Map<String, Object>)yaml.load(newContent);
                newMap = this.getFlattenedMap(newMap);
            }
        }
        catch (ConstructorException e) {
            this.handleYamlException(e);
        }
        return this.filterChangeData(oldMap, newMap);
    }

    private void handleYamlException(ConstructorException e) {
        if (e.getMessage().startsWith(INVALID_CONSTRUCTOR_ERROR_INFO)) {
            throw new NacosRuntimeException(400, "AbstractConfigChangeListener only support basic java data type for yaml. If you want to listen key changes for custom classes, please use `Listener` to listener whole yaml configuration and parse it by yourself.", (Throwable)e);
        }
        throw e;
    }

    private Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(128);
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> e : source.entrySet()) {
            String key = e.getKey();
            if (StringUtils.isNotBlank((String)path)) {
                key = e.getKey().startsWith("[") ? path + key : path + '.' + key;
            }
            if (e.getValue() instanceof String) {
                result.put(key, e.getValue());
                continue;
            }
            if (e.getValue() instanceof Map) {
                Map map = (Map)e.getValue();
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (e.getValue() instanceof Collection) {
                Collection collection = (Collection)e.getValue();
                if (collection.isEmpty()) {
                    result.put(key, "");
                    continue;
                }
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, e.getValue() != null ? e.getValue() : "");
        }
    }
}

