/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.processor.util;

import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class JavacUtil {
    public static JavacProcessingEnvironment getJavacProcessingEnvironment(Object procEnv) {
        if (procEnv instanceof JavacProcessingEnvironment) {
            return (JavacProcessingEnvironment)procEnv;
        }
        for (Class<?> procEnvClass = procEnv.getClass(); procEnvClass != null; procEnvClass = procEnvClass.getSuperclass()) {
            Object delegate = JavacUtil.tryGetDelegateField(procEnvClass, procEnv);
            if (delegate == null) {
                delegate = JavacUtil.tryGetProxyDelegateToField(procEnvClass, procEnv);
            }
            if (delegate == null) {
                delegate = JavacUtil.tryGetProcessingEnvField(procEnvClass, procEnv);
            }
            if (delegate == null) continue;
            return JavacUtil.getJavacProcessingEnvironment(delegate);
        }
        return null;
    }

    private static Object tryGetProxyDelegateToField(Class<?> delegateClass, Object instance) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            return JavacUtil.getField(handler.getClass(), "val$delegateTo").get(handler);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object tryGetDelegateField(Class<?> delegateClass, Object instance) {
        try {
            return JavacUtil.getField(delegateClass, "delegate").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object tryGetProcessingEnvField(Class<?> delegateClass, Object instance) {
        try {
            return JavacUtil.getField(delegateClass, "processingEnv").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Field getField(Class<?> c, String fName) throws NoSuchFieldException {
        Field f = null;
        Class<?> oc = c;
        while (c != null) {
            try {
                f = c.getDeclaredField(fName);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                c = c.getSuperclass();
            }
        }
        if (f == null) {
            throw new NoSuchFieldException(oc.getName() + " :: " + fName);
        }
        f.setAccessible(true);
        return f;
    }
}

