/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.httpclient;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class HttpClientStatReporter
extends AbstractSofaTracerStatisticReporter {
    public HttpClientStatReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatKey statKey = new StatKey();
        String localApp = (String)tagsWithStr.get("local.app");
        String requestUrl = (String)tagsWithStr.get("request.url");
        String methodName = (String)tagsWithStr.get("method");
        statKey.setKey(this.buildString(new String[]{localApp, requestUrl, methodName}));
        String resultCode = (String)tagsWithStr.get("result.code");
        boolean success = this.isWebHttpClientSuccess(resultCode);
        statKey.setResult(success ? "Y" : "N");
        statKey.setEnd(this.buildString(new String[]{TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan)}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat(statKey, values);
    }
}

