/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.httpclient.interceptor;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractTracer;
import com.alipay.sofa.tracer.plugins.httpclient.interceptor.AbstractHttpRequestInterceptor;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.protocol.HttpContext;

public class SofaTracerHttpInterceptor
extends AbstractHttpRequestInterceptor
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    public SofaTracerHttpInterceptor(AbstractTracer httpClientTracer, String appName, String targetAppName) {
        super(httpClientTracer, appName, targetAppName);
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        RequestLine requestLine = httpRequest.getRequestLine();
        String methodName = requestLine.getMethod();
        SofaTracerSpan httpClientSpan = this.httpClientTracer.clientSend(methodName);
        super.appendHttpClientRequestSpanTags(httpRequest, httpClientSpan);
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan httpClientSpan = sofaTraceContext.getCurrentSpan();
        super.appendHttpClientResponseSpanTags(httpResponse, httpClientSpan);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        this.httpClientTracer.clientReceive(String.valueOf(statusCode));
    }
}

