/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.listener;

import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.boot.properties.SofaTracerProperties;
import java.lang.annotation.Annotation;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SofaTracerConfigurationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (this.isSpringCloudBootstrapEnvironment((Environment)environment)) {
            return;
        }
        String applicationName = environment.getProperty("spring.application.name");
        Assert.isTrue((!StringUtils.isBlank((String)applicationName) ? 1 : 0) != 0, (String)"spring.application.name must be configured!");
        SofaTracerConfiguration.setProperty((String)"spring.application.name", (String)applicationName);
        SofaTracerProperties tempTarget = new SofaTracerProperties();
        ConfigurationProperties configurationProperties = (ConfigurationProperties)AnnotationUtils.findAnnotation(SofaTracerProperties.class, ConfigurationProperties.class);
        Binder binder = Binder.get((Environment)environment);
        Bindable bindable = Bindable.of(SofaTracerProperties.class).withExistingValue((Object)tempTarget).withAnnotations(new Annotation[]{configurationProperties});
        binder.bind("com.alipay.sofa.tracer", bindable);
        SofaTracerConfiguration.setProperty((String)"disable_middleware_digest_log", (String)tempTarget.getDisableDigestLog());
        SofaTracerConfiguration.setProperty((String)"disable_digest_log", tempTarget.getDisableConfiguration());
        SofaTracerConfiguration.setProperty((String)"tracer_global_rolling_policy", (String)tempTarget.getTracerGlobalRollingPolicy());
        SofaTracerConfiguration.setProperty((String)"tracer_global_log_reserve_day", (String)tempTarget.getTracerGlobalLogReserveDay());
        SofaTracerConfiguration.setProperty((String)"stat_log_interval", (String)tempTarget.getStatLogInterval());
        SofaTracerConfiguration.setProperty((String)"tracer_penetrate_attribute_max_length", (String)tempTarget.getBaggageMaxLength());
        SofaTracerConfiguration.setProperty((String)"tracer_system_penetrate_attribute_max_length", (String)tempTarget.getBaggageMaxLength());
        if (tempTarget.getSamplerName() != null) {
            SofaTracerConfiguration.setProperty((String)"tracer_sampler_strategy_name_key", (String)tempTarget.getSamplerName());
        }
        if (StringUtils.isNotBlank((String)tempTarget.getSamplerCustomRuleClassName())) {
            SofaTracerConfiguration.setProperty((String)"tracer_sampler_strategy_custom_rule_class_name", (String)tempTarget.getSamplerCustomRuleClassName());
        }
        SofaTracerConfiguration.setProperty((String)"tracer_sampler_strategy_percentage_key", (String)String.valueOf(tempTarget.getSamplerPercentage()));
        SofaTracerConfiguration.setProperty((String)"global_json_format_output", (String)String.valueOf(tempTarget.isJsonOutput()));
    }

    public int getOrder() {
        return -2147483618;
    }

    private boolean isSpringCloudBootstrapEnvironment(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return false;
        }
        return !((ConfigurableEnvironment)environment).getPropertySources().contains("sofaBootstrap") && this.isSpringCloud();
    }

    private boolean isSpringCloud() {
        return ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.BootstrapConfiguration", null);
    }
}

