/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.sts20150401.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AssumeRoleRequest
extends Request {
    @Query
    @NameInMap(value="DurationSeconds")
    private Long durationSeconds;
    @Query
    @NameInMap(value="ExternalId")
    private String externalId;
    @Query
    @NameInMap(value="Policy")
    private String policy;
    @Query
    @NameInMap(value="RoleArn")
    @Validation(required=true)
    private String roleArn;
    @Query
    @NameInMap(value="RoleSessionName")
    @Validation(required=true)
    private String roleSessionName;

    private AssumeRoleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.durationSeconds = builder.durationSeconds;
        this.externalId = builder.externalId;
        this.policy = builder.policy;
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AssumeRoleRequest create() {
        return AssumeRoleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDurationSeconds() {
        return this.durationSeconds;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getPolicy() {
        return this.policy;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public static final class Builder
    extends Request.Builder<AssumeRoleRequest, Builder> {
        private Long durationSeconds;
        private String externalId;
        private String policy;
        private String roleArn;
        private String roleSessionName;

        private Builder() {
        }

        private Builder(AssumeRoleRequest request) {
            super((Request)request);
            this.durationSeconds = request.durationSeconds;
            this.externalId = request.externalId;
            this.policy = request.policy;
            this.roleArn = request.roleArn;
            this.roleSessionName = request.roleSessionName;
        }

        public Builder durationSeconds(Long durationSeconds) {
            this.putQueryParameter("DurationSeconds", durationSeconds);
            this.durationSeconds = durationSeconds;
            return this;
        }

        public Builder externalId(String externalId) {
            this.putQueryParameter("ExternalId", externalId);
            this.externalId = externalId;
            return this;
        }

        public Builder policy(String policy) {
            this.putQueryParameter("Policy", policy);
            this.policy = policy;
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.putQueryParameter("RoleArn", roleArn);
            this.roleArn = roleArn;
            return this;
        }

        public Builder roleSessionName(String roleSessionName) {
            this.putQueryParameter("RoleSessionName", roleSessionName);
            this.roleSessionName = roleSessionName;
            return this;
        }

        public AssumeRoleRequest build() {
            return new AssumeRoleRequest(this);
        }
    }
}

