/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dingtalkdoc_2_0;

import com.aliyun.dingtalkdoc_2_0.models.CreateDentryHeaders;
import com.aliyun.dingtalkdoc_2_0.models.CreateDentryRequest;
import com.aliyun.dingtalkdoc_2_0.models.CreateDentryResponse;
import com.aliyun.dingtalkdoc_2_0.models.GetSpaceDirectoriesHeaders;
import com.aliyun.dingtalkdoc_2_0.models.GetSpaceDirectoriesRequest;
import com.aliyun.dingtalkdoc_2_0.models.GetSpaceDirectoriesResponse;
import com.aliyun.dingtalkdoc_2_0.models.MoveDentryHeaders;
import com.aliyun.dingtalkdoc_2_0.models.MoveDentryRequest;
import com.aliyun.dingtalkdoc_2_0.models.MoveDentryResponse;
import com.aliyun.dingtalkdoc_2_0.models.QueryDentryHeaders;
import com.aliyun.dingtalkdoc_2_0.models.QueryDentryRequest;
import com.aliyun.dingtalkdoc_2_0.models.QueryDentryResponse;
import com.aliyun.dingtalkdoc_2_0.models.QuerySpaceHeaders;
import com.aliyun.dingtalkdoc_2_0.models.QuerySpaceRequest;
import com.aliyun.dingtalkdoc_2_0.models.QuerySpaceResponse;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teaopenapi.models.OpenApiRequest;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.HashMap;
import java.util.Map;

public class Client
extends com.aliyun.teaopenapi.Client {
    public Client(Config config) throws Exception {
        super(config);
        this._endpointRule = "";
        if (Common.empty((String)this._endpoint)) {
            this._endpoint = "api.dingtalk.com";
        }
    }

    public CreateDentryResponse createDentry(String spaceId, CreateDentryRequest request) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        CreateDentryHeaders headers = new CreateDentryHeaders();
        return this.createDentryWithOptions(spaceId, request, headers, runtime);
    }

    public CreateDentryResponse createDentryWithOptions(String spaceId, CreateDentryRequest request, CreateDentryHeaders headers, RuntimeOptions runtime) throws Exception {
        Common.validateModel((TeaModel)request);
        spaceId = com.aliyun.openapiutil.Client.getEncodeParam((String)spaceId);
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (!Common.isUnset((Object)request.dentryType)) {
            body.put("dentryType", request.dentryType);
        }
        if (!Common.isUnset((Object)request.documentType)) {
            body.put("documentType", request.documentType);
        }
        if (!Common.isUnset((Object)request.name)) {
            body.put("name", request.name);
        }
        if (!Common.isUnset((Object)request.operatorId)) {
            body.put("operatorId", request.operatorId);
        }
        if (!Common.isUnset((Object)request.parentDentryId)) {
            body.put("parentDentryId", request.parentDentryId);
        }
        Map<Object, Object> realHeaders = new HashMap();
        if (!Common.isUnset(headers.commonHeaders)) {
            realHeaders = headers.commonHeaders;
        }
        if (!Common.isUnset((Object)headers.xAcsDingtalkAccessToken)) {
            realHeaders.put("x-acs-dingtalk-access-token", Common.toJSONString((Object)headers.xAcsDingtalkAccessToken));
        }
        OpenApiRequest req = OpenApiRequest.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", realHeaders), new TeaPair("body", (Object)com.aliyun.openapiutil.Client.parseToMap(body))}));
        return (CreateDentryResponse)TeaModel.toModel((Map)this.doROARequest("CreateDentry", "doc_2.0", "HTTP", "POST", "AK", "/v2.0/doc/spaces/" + spaceId + "/dentries", "json", req, runtime), (TeaModel)new CreateDentryResponse());
    }

    public GetSpaceDirectoriesResponse getSpaceDirectories(String spaceId, GetSpaceDirectoriesRequest request) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        GetSpaceDirectoriesHeaders headers = new GetSpaceDirectoriesHeaders();
        return this.getSpaceDirectoriesWithOptions(spaceId, request, headers, runtime);
    }

    public GetSpaceDirectoriesResponse getSpaceDirectoriesWithOptions(String spaceId, GetSpaceDirectoriesRequest request, GetSpaceDirectoriesHeaders headers, RuntimeOptions runtime) throws Exception {
        Common.validateModel((TeaModel)request);
        spaceId = com.aliyun.openapiutil.Client.getEncodeParam((String)spaceId);
        HashMap<String, Object> query = new HashMap<String, Object>();
        if (!Common.isUnset((Object)request.dentryId)) {
            query.put("dentryId", request.dentryId);
        }
        if (!Common.isUnset((Object)request.maxResults)) {
            query.put("maxResults", request.maxResults);
        }
        if (!Common.isUnset((Object)request.nextToken)) {
            query.put("nextToken", request.nextToken);
        }
        if (!Common.isUnset((Object)request.operatorId)) {
            query.put("operatorId", request.operatorId);
        }
        Map<Object, Object> realHeaders = new HashMap();
        if (!Common.isUnset(headers.commonHeaders)) {
            realHeaders = headers.commonHeaders;
        }
        if (!Common.isUnset((Object)headers.xAcsDingtalkAccessToken)) {
            realHeaders.put("x-acs-dingtalk-access-token", Common.toJSONString((Object)headers.xAcsDingtalkAccessToken));
        }
        OpenApiRequest req = OpenApiRequest.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", realHeaders), new TeaPair("query", (Object)com.aliyun.openapiutil.Client.query(query))}));
        return (GetSpaceDirectoriesResponse)TeaModel.toModel((Map)this.doROARequest("GetSpaceDirectories", "doc_2.0", "HTTP", "GET", "AK", "/v2.0/doc/spaces/" + spaceId + "/directories", "json", req, runtime), (TeaModel)new GetSpaceDirectoriesResponse());
    }

    public MoveDentryResponse moveDentry(String spaceId, String dentryId, MoveDentryRequest request) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        MoveDentryHeaders headers = new MoveDentryHeaders();
        return this.moveDentryWithOptions(spaceId, dentryId, request, headers, runtime);
    }

    public MoveDentryResponse moveDentryWithOptions(String spaceId, String dentryId, MoveDentryRequest request, MoveDentryHeaders headers, RuntimeOptions runtime) throws Exception {
        Common.validateModel((TeaModel)request);
        spaceId = com.aliyun.openapiutil.Client.getEncodeParam((String)spaceId);
        dentryId = com.aliyun.openapiutil.Client.getEncodeParam((String)dentryId);
        HashMap<String, String> body = new HashMap<String, String>();
        if (!Common.isUnset((Object)request.operatorId)) {
            body.put("operatorId", request.operatorId);
        }
        if (!Common.isUnset((Object)request.targetSpaceId)) {
            body.put("targetSpaceId", request.targetSpaceId);
        }
        if (!Common.isUnset((Object)request.toNextDentryId)) {
            body.put("toNextDentryId", request.toNextDentryId);
        }
        if (!Common.isUnset((Object)request.toParentDentryId)) {
            body.put("toParentDentryId", request.toParentDentryId);
        }
        if (!Common.isUnset((Object)request.toPrevDentryId)) {
            body.put("toPrevDentryId", request.toPrevDentryId);
        }
        Map<Object, Object> realHeaders = new HashMap();
        if (!Common.isUnset(headers.commonHeaders)) {
            realHeaders = headers.commonHeaders;
        }
        if (!Common.isUnset((Object)headers.xAcsDingtalkAccessToken)) {
            realHeaders.put("x-acs-dingtalk-access-token", Common.toJSONString((Object)headers.xAcsDingtalkAccessToken));
        }
        OpenApiRequest req = OpenApiRequest.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", realHeaders), new TeaPair("body", (Object)com.aliyun.openapiutil.Client.parseToMap(body))}));
        return (MoveDentryResponse)TeaModel.toModel((Map)this.doROARequest("MoveDentry", "doc_2.0", "HTTP", "POST", "AK", "/v2.0/doc/spaces/" + spaceId + "/dentries/" + dentryId + "/move", "json", req, runtime), (TeaModel)new MoveDentryResponse());
    }

    public QueryDentryResponse queryDentry(String spaceId, String dentryId, QueryDentryRequest request) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        QueryDentryHeaders headers = new QueryDentryHeaders();
        return this.queryDentryWithOptions(spaceId, dentryId, request, headers, runtime);
    }

    public QueryDentryResponse queryDentryWithOptions(String spaceId, String dentryId, QueryDentryRequest request, QueryDentryHeaders headers, RuntimeOptions runtime) throws Exception {
        Common.validateModel((TeaModel)request);
        spaceId = com.aliyun.openapiutil.Client.getEncodeParam((String)spaceId);
        dentryId = com.aliyun.openapiutil.Client.getEncodeParam((String)dentryId);
        HashMap<String, Object> query = new HashMap<String, Object>();
        if (!Common.isUnset((Object)request.includeSpace)) {
            query.put("includeSpace", request.includeSpace);
        }
        if (!Common.isUnset((Object)request.operatorId)) {
            query.put("operatorId", request.operatorId);
        }
        Map<Object, Object> realHeaders = new HashMap();
        if (!Common.isUnset(headers.commonHeaders)) {
            realHeaders = headers.commonHeaders;
        }
        if (!Common.isUnset((Object)headers.xAcsDingtalkAccessToken)) {
            realHeaders.put("x-acs-dingtalk-access-token", Common.toJSONString((Object)headers.xAcsDingtalkAccessToken));
        }
        OpenApiRequest req = OpenApiRequest.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", realHeaders), new TeaPair("query", (Object)com.aliyun.openapiutil.Client.query(query))}));
        return (QueryDentryResponse)TeaModel.toModel((Map)this.doROARequest("QueryDentry", "doc_2.0", "HTTP", "GET", "AK", "/v2.0/doc/spaces/" + spaceId + "/dentries/" + dentryId + "", "json", req, runtime), (TeaModel)new QueryDentryResponse());
    }

    public QuerySpaceResponse querySpace(String spaceId, QuerySpaceRequest request) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        QuerySpaceHeaders headers = new QuerySpaceHeaders();
        return this.querySpaceWithOptions(spaceId, request, headers, runtime);
    }

    public QuerySpaceResponse querySpaceWithOptions(String spaceId, QuerySpaceRequest request, QuerySpaceHeaders headers, RuntimeOptions runtime) throws Exception {
        Common.validateModel((TeaModel)request);
        spaceId = com.aliyun.openapiutil.Client.getEncodeParam((String)spaceId);
        HashMap<String, String> query = new HashMap<String, String>();
        if (!Common.isUnset((Object)request.operatorId)) {
            query.put("operatorId", request.operatorId);
        }
        Map<Object, Object> realHeaders = new HashMap();
        if (!Common.isUnset(headers.commonHeaders)) {
            realHeaders = headers.commonHeaders;
        }
        if (!Common.isUnset((Object)headers.xAcsDingtalkAccessToken)) {
            realHeaders.put("x-acs-dingtalk-access-token", Common.toJSONString((Object)headers.xAcsDingtalkAccessToken));
        }
        OpenApiRequest req = OpenApiRequest.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", realHeaders), new TeaPair("query", (Object)com.aliyun.openapiutil.Client.query(query))}));
        return (QuerySpaceResponse)TeaModel.toModel((Map)this.doROARequest("QuerySpace", "doc_2.0", "HTTP", "GET", "AK", "/v2.0/doc/spaces/" + spaceId + "", "json", req, runtime), (TeaModel)new QuerySpaceResponse());
    }
}

