/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.xa.XID;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RecoveryScan {
    public static List<XID> recoverXids(XAResource xaResource, XidSelector selector) throws XAException {
        ArrayList<XID> ret = new ArrayList<XID>();
        boolean done = false;
        int flags = 0x1000000;
        Xid[] xidsFromLastScan = null;
        ArrayList<XID> allRecoveredXidsSoFar = new ArrayList<XID>();
        do {
            xidsFromLastScan = xaResource.recover(flags);
            flags = 0;
            boolean bl = done = xidsFromLastScan == null || xidsFromLastScan.length == 0;
            if (done) continue;
            done = true;
            for (int i = 0; i < xidsFromLastScan.length; ++i) {
                XID xid = new XID(xidsFromLastScan[i]);
                if (allRecoveredXidsSoFar.contains(xid)) continue;
                allRecoveredXidsSoFar.add(xid);
                done = false;
                if (!selector.selects(xid)) continue;
                ret.add(xid);
            }
        } while (!done);
        return ret;
    }

    public static interface XidSelector {
        public boolean selects(Xid var1);
    }
}

