/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.SysException;
import com.atomikos.icatch.jta.RemoteClientUserTransaction;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionServerImp
implements UserTransactionServer {
    private static final Logger LOGGER = LoggerFactory.createLogger(UserTransactionServerImp.class);
    private static UserTransactionServerImp singleton_ = null;
    private String name_ = "UserTransactionServer";
    private boolean exported_ = false;
    private String initialContextFactory_;
    private String providerUrl_;
    private Properties properties_;

    public static synchronized UserTransactionServerImp getSingleton() {
        if (singleton_ == null) {
            singleton_ = new UserTransactionServerImp();
        }
        return singleton_;
    }

    private UserTransactionServerImp() {
    }

    private Context getInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        Enumeration<?> enumm = this.properties_.propertyNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            String value = this.properties_.getProperty(name);
            env.put(name, value);
        }
        return new InitialContext(env);
    }

    public UserTransaction getUserTransaction() {
        RemoteClientUserTransaction ret = null;
        if (this.exported_) {
            ret = new RemoteClientUserTransaction(this.getName(), this.initialContextFactory_, this.providerUrl_);
        }
        return ret;
    }

    public String getName() {
        return this.name_;
    }

    public void init(String tmUniqueName, Properties properties) throws SysException {
        boolean canExport = false;
        String exportClass = properties.getProperty("com.atomikos.icatch.rmi_export_class");
        boolean bl = canExport = "UnicastRemoteObject".equals(exportClass) || "PortableRemoteObject".equals(exportClass);
        if (!canExport) {
            LOGGER.logWarning("Client transaction demarcation not supported for com.atomikos.icatch.rmi_export_class=" + exportClass);
            this.exported_ = false;
        } else {
            this.name_ = tmUniqueName + "UserTransactionServer";
            this.providerUrl_ = properties.getProperty("java.naming.provider.url");
            if (this.providerUrl_ == null) {
                throw new SysException("Startup property java.naming.provider.url must be set for client demarcation.");
            }
            this.initialContextFactory_ = properties.getProperty("java.naming.factory.initial");
            if (this.initialContextFactory_ == null) {
                throw new SysException("Startup property java.naming.factory.initial must be set for client demarcation.");
            }
            this.properties_ = properties;
            try {
                if ("PortableRemoteObject".equals(exportClass)) {
                    PortableRemoteObject.exportObject((Remote)this);
                    this.exported_ = true;
                } else if ("UnicastRemoteObject".equals(exportClass)) {
                    UnicastRemoteObject.exportObject(this);
                    this.exported_ = true;
                }
            }
            catch (Exception e) {
                throw new SysException("Error exporting - naming service not running?", (Throwable)e);
            }
            try {
                Context ctx = this.getInitialContext();
                ctx.rebind(this.name_, (Object)this);
            }
            catch (Exception e) {
                throw new SysException("Please make sure the rmiregistry is running!?", (Throwable)e);
            }
        }
    }

    public void shutdown() throws SysException {
        if (this.exported_) {
            String exportClass = this.properties_.getProperty("com.atomikos.icatch.rmi_export_class");
            try {
                if ("PortableRemoteObject".equals(exportClass)) {
                    PortableRemoteObject.unexportObject((Remote)this);
                } else if ("UnicastRemoteObject".equals(exportClass)) {
                    UnicastRemoteObject.unexportObject(this, true);
                }
                Context ctx = this.getInitialContext();
                ctx.unbind(this.name_);
            }
            catch (Exception e) {
                throw new SysException(e.getMessage(), (Throwable)e);
            }
            this.exported_ = false;
        }
    }

    @Override
    public String begin(int timeout) throws RemoteException, SystemException, NotSupportedException {
        TransactionManagerImp tm = this.getTransactionManager();
        tm.begin(timeout);
        TransactionImp tx = (TransactionImp)tm.getTransaction();
        tx.getCT().setSerial();
        tm.suspend();
        return tx.getCT().getTid();
    }

    private TransactionManagerImp getTransactionManager() {
        TransactionManagerImp ret = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
        if (ret == null) {
            throw new SysException("Transaction manager not initialized?");
        }
        return ret;
    }

    @Override
    public void commit(String tid) throws RemoteException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImp tx = this.getTransactionManager().getJtaTransactionWithId(tid);
        if (tx == null) {
            throw new RollbackException("Transaction not found: " + tid);
        }
        tx.commit();
    }

    @Override
    public void rollback(String tid) throws RemoteException, IllegalStateException, SecurityException, SystemException {
        TransactionImp tx = this.getTransactionManager().getJtaTransactionWithId(tid);
        if (tx != null) {
            tx.rollback();
        }
    }

    @Override
    public void setRollbackOnly(String tid) throws RemoteException, IllegalStateException, SystemException {
        TransactionImp tx = this.getTransactionManager().getJtaTransactionWithId(tid);
        if (tx != null) {
            tx.setRollbackOnly();
        }
    }

    @Override
    public int getStatus(String tid) throws RemoteException, SystemException {
        int ret = 6;
        TransactionImp tx = this.getTransactionManager().getJtaTransactionWithId(tid);
        if (tx != null) {
            ret = tx.getStatus();
        }
        return ret;
    }
}

