/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.implementation.util.Base64Util;
import com.azure.core.util.logging.ClientLogger;
import java.io.UnsupportedEncodingException;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public class BasicAuthenticationCredential
implements TokenCredential {
    private final ClientLogger logger = new ClientLogger(BasicAuthenticationCredential.class);
    private final String username;
    private final String password;

    public BasicAuthenticationCredential(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        String encodedCredential;
        String credential = this.username + ":" + this.password;
        try {
            encodedCredential = Base64Util.encodeToString(credential.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        return Mono.just((Object)new AccessToken(encodedCredential, OffsetDateTime.MAX));
    }
}

