/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.util.Configuration;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLogger {
    private final Logger logger;
    private static final int VERBOSE_LEVEL = 1;
    private static final int INFORMATIONAL_LEVEL = 2;
    private static final int WARNING_LEVEL = 3;
    private static final int ERROR_LEVEL = 4;
    private static final int DISABLED_LEVEL = 5;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        this.logger = LoggerFactory.getLogger((String)className);
    }

    public void verbose(String format, Object ... args) {
        this.log(1, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(2, format, args);
    }

    public void warning(String format, Object ... args) {
        this.log(3, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(4, format, args);
    }

    private void log(int logLevel, String format, Object ... args) {
        if (this.canLogAtLevel(logLevel)) {
            this.performLogging(logLevel, format, args);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        return this.logException(runtimeException, 3);
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        return this.logException(runtimeException, 4);
    }

    private RuntimeException logException(RuntimeException runtimeException, int logLevel) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (this.canLogAtLevel(logLevel)) {
            this.log(logLevel, runtimeException.getMessage(), runtimeException);
        }
        return runtimeException;
    }

    private void performLogging(int logLevel, String format, Object ... args) {
        if (logLevel > 1) {
            args = this.attemptToRemoveThrowable(args);
        }
        switch (logLevel) {
            case 1: {
                this.logger.debug(format, args);
                break;
            }
            case 2: {
                this.logger.info(format, args);
                break;
            }
            case 3: {
                this.logger.warn(format, args);
                break;
            }
            case 4: {
                this.logger.error(format, args);
                break;
            }
        }
    }

    private boolean canLogAtLevel(int level) {
        int configurationLevel = Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL", 5);
        if (level < configurationLevel) {
            return false;
        }
        switch (level) {
            case 1: {
                return this.logger != null && this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger != null && this.logger.isInfoEnabled();
            }
            case 3: {
                return this.logger != null && this.logger.isWarnEnabled();
            }
            case 4: {
                return this.logger != null && this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private Object[] attemptToRemoveThrowable(Object ... args) {
        if (args.length == 0) {
            return args;
        }
        Object potentialThrowable = args[args.length - 1];
        if (potentialThrowable instanceof Throwable) {
            return Arrays.copyOf(args, args.length - 1);
        }
        return args;
    }
}

