/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.implementation.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class AsyncPollResponse<T, U> {
    private final ClientLogger logger = new ClientLogger(AsyncPollResponse.class);
    private final PollingContext<T> pollingContext;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancellationOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final PollResponse<T> pollResponse;

    AsyncPollResponse(PollingContext<T> pollingContext, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancellationOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation) {
        this.pollingContext = Objects.requireNonNull(pollingContext, "'pollingContext' cannot be null.");
        this.cancellationOperation = Objects.requireNonNull(cancellationOperation, "'cancellationOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(fetchResultOperation, "'fetchResultOperation' cannot be null.");
        this.pollResponse = this.pollingContext.getLatestResponse();
    }

    public LongRunningOperationStatus getStatus() {
        return this.pollResponse.getStatus();
    }

    public T getValue() {
        return this.pollResponse.getValue();
    }

    public Mono<T> cancelOperation() {
        return Mono.defer(() -> {
            try {
                return this.cancellationOperation.apply(this.pollingContext, this.pollingContext.getActivationResponse());
            }
            catch (RuntimeException re) {
                return FluxUtil.monoError(this.logger, re);
            }
        });
    }

    public Mono<U> getFinalResult() {
        return Mono.defer(() -> {
            if (!this.pollResponse.getStatus().isComplete()) {
                return Mono.empty();
            }
            try {
                return this.fetchResultOperation.apply(this.pollingContext);
            }
            catch (RuntimeException re) {
                return FluxUtil.monoError(this.logger, re);
            }
        });
    }

    Duration getRetryAfter() {
        return this.pollResponse.getRetryAfter();
    }
}

