/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.tracing.Tracer;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.TracerProvider;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetrics;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public final class CosmosAsyncClient
implements Closeable {
    private final Configs configs;
    private final AsyncDocumentClient asyncDocumentClient;
    private final String serviceEndpoint;
    private final String keyOrResourceToken;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel desiredConsistencyLevel;
    private final List<CosmosPermissionProperties> permissions;
    private final CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private final AzureKeyCredential credential;
    private final boolean sessionCapturingOverride;
    private final boolean enableTransportClientSharing;
    private final TracerProvider tracerProvider;
    private final boolean contentResponseOnWriteEnabled;
    private static final Tracer TRACER;

    CosmosAsyncClient(CosmosClientBuilder builder) {
        this.configs = builder.configs();
        this.serviceEndpoint = builder.getEndpoint();
        this.keyOrResourceToken = builder.getKey();
        this.connectionPolicy = builder.getConnectionPolicy();
        this.desiredConsistencyLevel = builder.getConsistencyLevel();
        this.permissions = builder.getPermissions();
        this.cosmosAuthorizationTokenResolver = builder.getAuthorizationTokenResolver();
        this.credential = builder.getCredential();
        this.sessionCapturingOverride = builder.isSessionCapturingOverrideEnabled();
        this.enableTransportClientSharing = builder.isConnectionSharingAcrossClientsEnabled();
        this.contentResponseOnWriteEnabled = builder.isContentResponseOnWriteEnabled();
        this.tracerProvider = new TracerProvider(TRACER);
        this.asyncDocumentClient = new AsyncDocumentClient.Builder().withServiceEndpoint(this.serviceEndpoint).withMasterKeyOrResourceToken(this.keyOrResourceToken).withConnectionPolicy(this.connectionPolicy).withConsistencyLevel(this.desiredConsistencyLevel).withSessionCapturingOverride(this.sessionCapturingOverride).withConfigs(this.configs).withTokenResolver(this.cosmosAuthorizationTokenResolver).withCredential(this.credential).withTransportClientSharing(this.enableTransportClientSharing).withContentResponseOnWriteEnabled(this.contentResponseOnWriteEnabled).build();
    }

    AsyncDocumentClient getContextClient() {
        return this.asyncDocumentClient;
    }

    static void setMonitorTelemetry(MeterRegistry registry) {
        RntbdMetrics.add(registry);
    }

    String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    String getKeyOrResourceToken() {
        return this.keyOrResourceToken;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    ConsistencyLevel getDesiredConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    List<CosmosPermissionProperties> getPermissions() {
        return this.permissions;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.asyncDocumentClient;
    }

    Configs getConfigs() {
        return this.configs;
    }

    CosmosAuthorizationTokenResolver getCosmosAuthorizationTokenResolver() {
        return this.cosmosAuthorizationTokenResolver;
    }

    AzureKeyCredential credential() {
        return this.credential;
    }

    boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) {
        return FluxUtil.withContext(context -> this.createDatabaseIfNotExistsInternal(this.getDatabase(databaseProperties.getId()), null, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id) {
        return FluxUtil.withContext(context -> this.createDatabaseIfNotExistsInternal(this.getDatabase(id), null, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id, ThroughputProperties throughputProperties) {
        return FluxUtil.withContext(context -> this.createDatabaseIfNotExistsInternal(this.getDatabase(id), throughputProperties, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) {
        CosmosDatabaseRequestOptions requestOptions = options == null ? new CosmosDatabaseRequestOptions() : options;
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseProperties.getId());
        return FluxUtil.withContext(context -> this.createDatabaseInternal(wrappedDatabase, requestOptions, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties) {
        return this.createDatabase(databaseProperties, new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id) {
        return this.createDatabase(new CosmosDatabaseProperties(id), new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseProperties.getId());
        CosmosDatabaseRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.createDatabaseInternal(wrappedDatabase, requestOptions, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createDatabase(databaseProperties, options);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id, ThroughputProperties throughputProperties) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createDatabase(new CosmosDatabaseProperties(id), options);
    }

    CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerInformation(this.tracerProvider, "readAllDatabases", this.serviceEndpoint, null);
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().readDatabases(options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosDatabasePropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases() {
        return this.readAllDatabases(new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryDatabasesInternal(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryDatabasesInternal(querySpec, options);
    }

    public CosmosAsyncDatabase getDatabase(String id) {
        return new CosmosAsyncDatabase(id, this);
    }

    @Override
    public void close() {
        this.asyncDocumentClient.close();
    }

    TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    private CosmosPagedFlux<CosmosDatabaseProperties> queryDatabasesInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerInformation(this.tracerProvider, "queryDatabases", this.serviceEndpoint, null);
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().queryDatabases(querySpec, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosDatabasePropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    private Mono<CosmosDatabaseResponse> createDatabaseIfNotExistsInternal(CosmosAsyncDatabase database, ThroughputProperties throughputProperties, Context context) {
        String spanName = "createDatabaseIfNotExists." + database.getId();
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        Mono responseMono = database.readInternal(new CosmosDatabaseRequestOptions(), nestedContext).onErrorResume(exception -> {
            CosmosException cosmosException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosException && (cosmosException = (CosmosException)((Object)((Object)unwrappedException))).getStatusCode() == 404) {
                CosmosDatabaseRequestOptions requestOptions = new CosmosDatabaseRequestOptions();
                if (throughputProperties != null) {
                    ModelBridgeInternal.setThroughputProperties(requestOptions, throughputProperties);
                }
                Database wrappedDatabase = new Database();
                wrappedDatabase.setId(database.getId());
                return this.createDatabaseInternal(wrappedDatabase, requestOptions, nestedContext);
            }
            return Mono.error((Throwable)unwrappedException);
        });
        return this.tracerProvider.traceEnabledCosmosResponsePublisher(responseMono, context, spanName, database.getId(), this.serviceEndpoint);
    }

    private Mono<CosmosDatabaseResponse> createDatabaseInternal(Database database, CosmosDatabaseRequestOptions options, Context context) {
        String spanName = "createDatabase." + database.getId();
        Mono responseMono = this.asyncDocumentClient.createDatabase(database, ModelBridgeInternal.toRequestOptions(options)).map(databaseResourceResponse -> ModelBridgeInternal.createCosmosDatabaseResponse(databaseResourceResponse)).single();
        return this.tracerProvider.traceEnabledCosmosResponsePublisher(responseMono, context, spanName, database.getId(), this.serviceEndpoint);
    }

    static {
        ServiceLoader<Tracer> serviceLoader = ServiceLoader.load(Tracer.class);
        Iterator<Tracer> iterator = serviceLoader.iterator();
        TRACER = iterator.hasNext() ? serviceLoader.iterator().next() : null;
    }
}

