/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.ReactorNettyClient;
import java.time.Duration;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;

public interface HttpClient {
    public Mono<HttpResponse> send(HttpRequest var1);

    public static HttpClient createFixed(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        Duration maxIdleConnectionTimeoutInMillis = httpClientConfig.getConfigs().getMaxIdleConnectionTimeout();
        if (httpClientConfig.getMaxIdleConnectionTimeout() != null) {
            maxIdleConnectionTimeoutInMillis = httpClientConfig.getMaxIdleConnectionTimeout();
        }
        Integer maxPoolSize = httpClientConfig.getConfigs().getReactorNettyMaxConnectionPoolSize();
        if (httpClientConfig.getMaxPoolSize() != null) {
            maxPoolSize = httpClientConfig.getMaxPoolSize();
        }
        Duration connectionAcquireTimeout = httpClientConfig.getConfigs().getConnectionAcquireTimeout();
        ConnectionProvider fixedConnectionProvider = ConnectionProvider.fixed((String)httpClientConfig.getConfigs().getReactorNettyConnectionPoolName(), (int)maxPoolSize, (long)connectionAcquireTimeout.toMillis(), (Duration)maxIdleConnectionTimeoutInMillis);
        return ReactorNettyClient.createWithConnectionProvider(fixedConnectionProvider, httpClientConfig);
    }

    public static HttpClient create(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        return ReactorNettyClient.create(httpClientConfig);
    }

    public void shutdown();
}

