/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.query.AggregateItem;
import com.azure.cosmos.implementation.query.aggregation.AggregateOperator;
import com.azure.cosmos.implementation.query.aggregation.Aggregator;
import com.azure.cosmos.implementation.query.aggregation.AverageAggregator;
import com.azure.cosmos.implementation.query.aggregation.CountAggregator;
import com.azure.cosmos.implementation.query.aggregation.MaxAggregator;
import com.azure.cosmos.implementation.query.aggregation.MinAggregator;
import com.azure.cosmos.implementation.query.aggregation.SumAggregator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SingleGroupAggregator {
    public static SingleGroupAggregator create(List<AggregateOperator> aggregates, Map<String, AggregateOperator> aggregateAliasToAggregateType, List<String> orderedAliases, boolean hasSelectValue, String continuationToken) {
        if (aggregates == null) {
            throw new IllegalArgumentException("aggregates");
        }
        if (aggregateAliasToAggregateType == null) {
            throw new IllegalArgumentException("aggregates");
        }
        SingleGroupAggregator singleGroupAggregator = hasSelectValue ? (!aggregates.isEmpty() ? SelectValueAggregateValues.create(aggregates.get(0), continuationToken) : SelectValueAggregateValues.create(null, continuationToken)) : SelectListAggregateValues.create(aggregateAliasToAggregateType, orderedAliases, continuationToken);
        return singleGroupAggregator;
    }

    public abstract void addValues(Document var1);

    public abstract Document getResult();

    public abstract Resource getDocumentContinuationToken();

    static class ScalarAggregateValue
    extends AggregateValue {
        private Object value;
        private boolean initialized;

        ScalarAggregateValue(Object value, boolean initialized) {
            this.value = value;
            this.initialized = initialized;
        }

        public static ScalarAggregateValue create(String continuationToken) {
            return new ScalarAggregateValue(null, false);
        }

        @Override
        void addValue(Object aggregateValue) {
            if (!this.initialized) {
                this.value = aggregateValue;
                this.initialized = true;
            }
        }

        @Override
        Object getResult() {
            if (!this.initialized) {
                throw new IllegalStateException("ScalarAggregateValue is not yet initialized.");
            }
            return this.value;
        }

        @Override
        Resource getDocumentContinuationToken() {
            return null;
        }
    }

    static class AggregateAggregateValue
    extends AggregateValue {
        private final Aggregator aggregator;

        AggregateAggregateValue(Aggregator aggregator) {
            this.aggregator = aggregator;
        }

        public static AggregateAggregateValue createAggregateValue(AggregateOperator aggregateOperator, String continuationToken) {
            Aggregator aggregator = null;
            switch (aggregateOperator) {
                case Average: {
                    aggregator = new AverageAggregator();
                    break;
                }
                case Count: {
                    aggregator = new CountAggregator();
                    break;
                }
                case Max: {
                    aggregator = new MaxAggregator();
                    break;
                }
                case Min: {
                    aggregator = new MinAggregator();
                    break;
                }
                case Sum: {
                    aggregator = new SumAggregator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown aggregator type: " + (Object)((Object)aggregateOperator));
                }
            }
            return new AggregateAggregateValue(aggregator);
        }

        @Override
        void addValue(Object aggregateValue) {
            AggregateItem aggregateItem = new AggregateItem(aggregateValue);
            this.aggregator.aggregate(aggregateItem.getItem());
        }

        @Override
        Object getResult() {
            return this.aggregator.getResult();
        }

        @Override
        Resource getDocumentContinuationToken() {
            return null;
        }
    }

    private static abstract class AggregateValue {
        private AggregateValue() {
        }

        public static AggregateValue create(AggregateOperator aggregateOperator, String continuationToken) {
            AggregateValue value = aggregateOperator != null ? AggregateAggregateValue.createAggregateValue(aggregateOperator, continuationToken) : ScalarAggregateValue.create(continuationToken);
            return value;
        }

        abstract void addValue(Object var1);

        abstract Object getResult();

        abstract Resource getDocumentContinuationToken();
    }

    public static final class SelectListAggregateValues
    extends SingleGroupAggregator {
        Map<String, AggregateValue> aliasToValue;
        List<String> orderedAliases;

        private SelectListAggregateValues(Map<String, AggregateValue> aliasToValue, List<String> orderedAliases) {
            this.aliasToValue = aliasToValue;
            this.orderedAliases = orderedAliases;
        }

        public static SingleGroupAggregator create(Map<String, AggregateOperator> aggregateAliasToAggregateType, List<String> orderedAliases, String continuationToken) {
            if (aggregateAliasToAggregateType == null) {
                throw new IllegalArgumentException("aggregateAliasToAggregateType cannot be null");
            }
            if (orderedAliases == null) {
                throw new IllegalArgumentException("orderedAliases cannot be null");
            }
            HashMap<String, AggregateValue> groupingTable = new HashMap<String, AggregateValue>();
            for (Map.Entry<String, AggregateOperator> aliasToAggregate : aggregateAliasToAggregateType.entrySet()) {
                String alias = aliasToAggregate.getKey();
                AggregateOperator aggregateOperator = null;
                if (aliasToAggregate.getValue() != null) {
                    aggregateOperator = AggregateOperator.valueOf(String.valueOf((Object)aliasToAggregate.getValue()));
                }
                AggregateValue aggregateValue = AggregateValue.create(aggregateOperator, continuationToken);
                groupingTable.put(alias, aggregateValue);
            }
            return new SelectListAggregateValues(groupingTable, orderedAliases);
        }

        @Override
        public void addValues(Document values) {
            for (Map.Entry<String, AggregateValue> aliasAndValue : this.aliasToValue.entrySet()) {
                String alias = aliasAndValue.getKey();
                AggregateValue aggregateValue = aliasAndValue.getValue();
                aggregateValue.addValue(values.get(alias));
            }
        }

        @Override
        public Document getResult() {
            Document aggregateDocument = new Document();
            for (String alias : this.orderedAliases) {
                AggregateValue aggregateValue = this.aliasToValue.get(alias);
                if (aggregateValue.getResult() == null) continue;
                aggregateDocument.set(alias, aggregateValue.getResult());
            }
            return aggregateDocument;
        }

        @Override
        public Resource getDocumentContinuationToken() {
            return null;
        }
    }

    public static final class SelectValueAggregateValues
    extends SingleGroupAggregator {
        private final AggregateValue aggregateValue;

        public SelectValueAggregateValues(AggregateValue aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        public static SingleGroupAggregator create(AggregateOperator aggregateOperator, String continuationToken) {
            AggregateValue aggregateValue = AggregateValue.create(aggregateOperator, continuationToken);
            return new SelectValueAggregateValues(aggregateValue);
        }

        @Override
        public void addValues(Document values) {
            this.aggregateValue.addValue(values);
        }

        @Override
        public Document getResult() {
            Document document;
            Object result = this.aggregateValue.getResult();
            if (result instanceof Document) {
                document = (Document)this.aggregateValue.getResult();
            } else {
                document = new Document();
                if (result instanceof Undefined) {
                    result = null;
                }
                document.set("_value", result);
            }
            return document;
        }

        @Override
        public Resource getDocumentContinuationToken() {
            return null;
        }
    }
}

