/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.HubVirtualNetworkConnectionProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class HubVirtualNetworkConnectionInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HubVirtualNetworkConnectionInner.class);
    @JsonProperty(value="properties")
    private HubVirtualNetworkConnectionProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private HubVirtualNetworkConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public HubVirtualNetworkConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public HubVirtualNetworkConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public SubResource remoteVirtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteVirtualNetwork();
    }

    public HubVirtualNetworkConnectionInner withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubVirtualNetworkConnectionProperties();
        }
        this.innerProperties().withRemoteVirtualNetwork(remoteVirtualNetwork);
        return this;
    }

    public Boolean allowHubToRemoteVnetTransit() {
        return this.innerProperties() == null ? null : this.innerProperties().allowHubToRemoteVnetTransit();
    }

    public HubVirtualNetworkConnectionInner withAllowHubToRemoteVnetTransit(Boolean allowHubToRemoteVnetTransit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubVirtualNetworkConnectionProperties();
        }
        this.innerProperties().withAllowHubToRemoteVnetTransit(allowHubToRemoteVnetTransit);
        return this;
    }

    public Boolean allowRemoteVnetToUseHubVnetGateways() {
        return this.innerProperties() == null ? null : this.innerProperties().allowRemoteVnetToUseHubVnetGateways();
    }

    public HubVirtualNetworkConnectionInner withAllowRemoteVnetToUseHubVnetGateways(Boolean allowRemoteVnetToUseHubVnetGateways) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubVirtualNetworkConnectionProperties();
        }
        this.innerProperties().withAllowRemoteVnetToUseHubVnetGateways(allowRemoteVnetToUseHubVnetGateways);
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.innerProperties() == null ? null : this.innerProperties().enableInternetSecurity();
    }

    public HubVirtualNetworkConnectionInner withEnableInternetSecurity(Boolean enableInternetSecurity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubVirtualNetworkConnectionProperties();
        }
        this.innerProperties().withEnableInternetSecurity(enableInternetSecurity);
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().routingConfiguration();
    }

    public HubVirtualNetworkConnectionInner withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubVirtualNetworkConnectionProperties();
        }
        this.innerProperties().withRoutingConfiguration(routingConfiguration);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

