/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class HubVirtualNetworkConnectionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HubVirtualNetworkConnectionProperties.class);
    @JsonProperty(value="remoteVirtualNetwork")
    private SubResource remoteVirtualNetwork;
    @JsonProperty(value="allowHubToRemoteVnetTransit")
    private Boolean allowHubToRemoteVnetTransit;
    @JsonProperty(value="allowRemoteVnetToUseHubVnetGateways")
    private Boolean allowRemoteVnetToUseHubVnetGateways;
    @JsonProperty(value="enableInternetSecurity")
    private Boolean enableInternetSecurity;
    @JsonProperty(value="routingConfiguration")
    private RoutingConfiguration routingConfiguration;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    public HubVirtualNetworkConnectionProperties withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    public Boolean allowHubToRemoteVnetTransit() {
        return this.allowHubToRemoteVnetTransit;
    }

    public HubVirtualNetworkConnectionProperties withAllowHubToRemoteVnetTransit(Boolean allowHubToRemoteVnetTransit) {
        this.allowHubToRemoteVnetTransit = allowHubToRemoteVnetTransit;
        return this;
    }

    public Boolean allowRemoteVnetToUseHubVnetGateways() {
        return this.allowRemoteVnetToUseHubVnetGateways;
    }

    public HubVirtualNetworkConnectionProperties withAllowRemoteVnetToUseHubVnetGateways(Boolean allowRemoteVnetToUseHubVnetGateways) {
        this.allowRemoteVnetToUseHubVnetGateways = allowRemoteVnetToUseHubVnetGateways;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public HubVirtualNetworkConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public HubVirtualNetworkConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }
}

