/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.LoadBalancerOutboundRuleProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class OutboundRulePropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OutboundRulePropertiesFormat.class);
    @JsonProperty(value="allocatedOutboundPorts")
    private Integer allocatedOutboundPorts;
    @JsonProperty(value="frontendIPConfigurations", required=true)
    private List<SubResource> frontendIpConfigurations;
    @JsonProperty(value="backendAddressPool", required=true)
    private SubResource backendAddressPool;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="protocol", required=true)
    private LoadBalancerOutboundRuleProtocol protocol;
    @JsonProperty(value="enableTcpReset")
    private Boolean enableTcpReset;
    @JsonProperty(value="idleTimeoutInMinutes")
    private Integer idleTimeoutInMinutes;

    public Integer allocatedOutboundPorts() {
        return this.allocatedOutboundPorts;
    }

    public OutboundRulePropertiesFormat withAllocatedOutboundPorts(Integer allocatedOutboundPorts) {
        this.allocatedOutboundPorts = allocatedOutboundPorts;
        return this;
    }

    public List<SubResource> frontendIpConfigurations() {
        return this.frontendIpConfigurations;
    }

    public OutboundRulePropertiesFormat withFrontendIpConfigurations(List<SubResource> frontendIpConfigurations) {
        this.frontendIpConfigurations = frontendIpConfigurations;
        return this;
    }

    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    public OutboundRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public LoadBalancerOutboundRuleProtocol protocol() {
        return this.protocol;
    }

    public OutboundRulePropertiesFormat withProtocol(LoadBalancerOutboundRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Boolean enableTcpReset() {
        return this.enableTcpReset;
    }

    public OutboundRulePropertiesFormat withEnableTcpReset(Boolean enableTcpReset) {
        this.enableTcpReset = enableTcpReset;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public OutboundRulePropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public void validate() {
        if (this.frontendIpConfigurations() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property frontendIpConfigurations in model OutboundRulePropertiesFormat"));
        }
        if (this.backendAddressPool() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property backendAddressPool in model OutboundRulePropertiesFormat"));
        }
        if (this.protocol() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocol in model OutboundRulePropertiesFormat"));
        }
    }
}

