/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class P2SConnectionConfigurationProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(P2SConnectionConfigurationProperties.class);
    @JsonProperty(value="vpnClientAddressPool")
    private AddressSpace vpnClientAddressPool;
    @JsonProperty(value="routingConfiguration")
    private RoutingConfiguration routingConfiguration;
    @JsonProperty(value="enableInternetSecurity")
    private Boolean enableInternetSecurity;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    public P2SConnectionConfigurationProperties withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public P2SConnectionConfigurationProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public P2SConnectionConfigurationProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.vpnClientAddressPool() != null) {
            this.vpnClientAddressPool().validate();
        }
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }
}

