/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NatGatewayInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressPropertiesFormatInner;
import com.azure.resourcemanager.network.models.DdosSettings;
import com.azure.resourcemanager.network.models.DeleteOptions;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.network.models.PublicIpAddressMigrationPhase;
import com.azure.resourcemanager.network.models.PublicIpAddressSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class PublicIpAddressInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PublicIpAddressInner.class);
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="sku")
    private PublicIpAddressSku sku;
    @JsonProperty(value="properties")
    private PublicIpAddressPropertiesFormatInner innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public PublicIpAddressInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public PublicIpAddressSku sku() {
        return this.sku;
    }

    public PublicIpAddressInner withSku(PublicIpAddressSku sku) {
        this.sku = sku;
        return this;
    }

    private PublicIpAddressPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public PublicIpAddressInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String id() {
        return this.id;
    }

    public PublicIpAddressInner withId(String id) {
        this.id = id;
        return this;
    }

    public PublicIpAddressInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PublicIpAddressInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public IpAllocationMethod publicIpAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAllocationMethod();
    }

    public PublicIpAddressInner withPublicIpAllocationMethod(IpAllocationMethod publicIpAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpAllocationMethod(publicIpAllocationMethod);
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressVersion();
    }

    public PublicIpAddressInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpAddressVersion(publicIpAddressVersion);
        return this;
    }

    public IpConfigurationInner ipConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfiguration();
    }

    public PublicIpAddressDnsSettings dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    public PublicIpAddressInner withDnsSettings(PublicIpAddressDnsSettings dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    public DdosSettings ddosSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().ddosSettings();
    }

    public PublicIpAddressInner withDdosSettings(DdosSettings ddosSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withDdosSettings(ddosSettings);
        return this;
    }

    public List<IpTag> ipTags() {
        return this.innerProperties() == null ? null : this.innerProperties().ipTags();
    }

    public PublicIpAddressInner withIpTags(List<IpTag> ipTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withIpTags(ipTags);
        return this;
    }

    public String ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public PublicIpAddressInner withIpAddress(String ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefix();
    }

    public PublicIpAddressInner withPublicIpPrefix(SubResource publicIpPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpPrefix(publicIpPrefix);
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public PublicIpAddressInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PublicIpAddressInner servicePublicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().servicePublicIpAddress();
    }

    public PublicIpAddressInner withServicePublicIpAddress(PublicIpAddressInner servicePublicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withServicePublicIpAddress(servicePublicIpAddress);
        return this;
    }

    public NatGatewayInner natGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().natGateway();
    }

    public PublicIpAddressInner withNatGateway(NatGatewayInner natGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withNatGateway(natGateway);
        return this;
    }

    public PublicIpAddressMigrationPhase migrationPhase() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationPhase();
    }

    public PublicIpAddressInner withMigrationPhase(PublicIpAddressMigrationPhase migrationPhase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withMigrationPhase(migrationPhase);
        return this;
    }

    public PublicIpAddressInner linkedPublicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedPublicIpAddress();
    }

    public PublicIpAddressInner withLinkedPublicIpAddress(PublicIpAddressInner linkedPublicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withLinkedPublicIpAddress(linkedPublicIpAddress);
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    public PublicIpAddressInner withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

