/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.RouteInner;
import com.azure.resourcemanager.network.fluent.models.RouteTablePropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class RouteTableInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteTableInner.class);
    @JsonProperty(value="properties")
    private RouteTablePropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private RouteTablePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public RouteTableInner withId(String id) {
        this.id = id;
        return this;
    }

    public RouteTableInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RouteTableInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<RouteInner> routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    public RouteTableInner withRoutes(List<RouteInner> routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteTablePropertiesFormat();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public Boolean disableBgpRoutePropagation() {
        return this.innerProperties() == null ? null : this.innerProperties().disableBgpRoutePropagation();
    }

    public RouteTableInner withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteTablePropertiesFormat();
        }
        this.innerProperties().withDisableBgpRoutePropagation(disableBgpRoutePropagation);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

