/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.RoutingIntentProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RoutingIntentInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RoutingIntentInner.class);
    @JsonProperty(value="properties")
    private RoutingIntentProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private RoutingIntentProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public RoutingIntentInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public RoutingIntentInner withId(String id) {
        super.withId(id);
        return this;
    }

    public List<RoutingPolicy> routingPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().routingPolicies();
    }

    public RoutingIntentInner withRoutingPolicies(List<RoutingPolicy> routingPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingIntentProperties();
        }
        this.innerProperties().withRoutingPolicies(routingPolicies);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

