/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewaySslProfilePropertiesFormat;
import com.azure.resourcemanager.network.models.ApplicationGatewayClientAuthConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ApplicationGatewaySslProfile
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewaySslProfile.class);
    @JsonProperty(value="properties")
    private ApplicationGatewaySslProfilePropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private ApplicationGatewaySslProfilePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ApplicationGatewaySslProfile withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ApplicationGatewaySslProfile withId(String id) {
        super.withId(id);
        return this;
    }

    public List<SubResource> trustedClientCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().trustedClientCertificates();
    }

    public ApplicationGatewaySslProfile withTrustedClientCertificates(List<SubResource> trustedClientCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslProfilePropertiesFormat();
        }
        this.innerProperties().withTrustedClientCertificates(trustedClientCertificates);
        return this;
    }

    public ApplicationGatewaySslPolicy sslPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().sslPolicy();
    }

    public ApplicationGatewaySslProfile withSslPolicy(ApplicationGatewaySslPolicy sslPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslProfilePropertiesFormat();
        }
        this.innerProperties().withSslPolicy(sslPolicy);
        return this;
    }

    public ApplicationGatewayClientAuthConfiguration clientAuthConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAuthConfiguration();
    }

    public ApplicationGatewaySslProfile withClientAuthConfiguration(ApplicationGatewayClientAuthConfiguration clientAuthConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslProfilePropertiesFormat();
        }
        this.innerProperties().withClientAuthConfiguration(clientAuthConfiguration);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

