/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallDisabledRuleGroup;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallExclusion;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ApplicationGatewayWebApplicationFirewallConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewayWebApplicationFirewallConfiguration.class);
    @JsonProperty(value="enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="firewallMode", required=true)
    private ApplicationGatewayFirewallMode firewallMode;
    @JsonProperty(value="ruleSetType", required=true)
    private String ruleSetType;
    @JsonProperty(value="ruleSetVersion", required=true)
    private String ruleSetVersion;
    @JsonProperty(value="disabledRuleGroups")
    private List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups;
    @JsonProperty(value="requestBodyCheck")
    private Boolean requestBodyCheck;
    @JsonProperty(value="maxRequestBodySize")
    private Integer maxRequestBodySize;
    @JsonProperty(value="maxRequestBodySizeInKb")
    private Integer maxRequestBodySizeInKb;
    @JsonProperty(value="fileUploadLimitInMb")
    private Integer fileUploadLimitInMb;
    @JsonProperty(value="exclusions")
    private List<ApplicationGatewayFirewallExclusion> exclusions;

    public boolean enabled() {
        return this.enabled;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ApplicationGatewayFirewallMode firewallMode() {
        return this.firewallMode;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withFirewallMode(ApplicationGatewayFirewallMode firewallMode) {
        this.firewallMode = firewallMode;
        return this;
    }

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups() {
        return this.disabledRuleGroups;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withDisabledRuleGroups(List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups) {
        this.disabledRuleGroups = disabledRuleGroups;
        return this;
    }

    public Boolean requestBodyCheck() {
        return this.requestBodyCheck;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withRequestBodyCheck(Boolean requestBodyCheck) {
        this.requestBodyCheck = requestBodyCheck;
        return this;
    }

    public Integer maxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withMaxRequestBodySize(Integer maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
        return this;
    }

    public Integer maxRequestBodySizeInKb() {
        return this.maxRequestBodySizeInKb;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withMaxRequestBodySizeInKb(Integer maxRequestBodySizeInKb) {
        this.maxRequestBodySizeInKb = maxRequestBodySizeInKb;
        return this;
    }

    public Integer fileUploadLimitInMb() {
        return this.fileUploadLimitInMb;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withFileUploadLimitInMb(Integer fileUploadLimitInMb) {
        this.fileUploadLimitInMb = fileUploadLimitInMb;
        return this;
    }

    public List<ApplicationGatewayFirewallExclusion> exclusions() {
        return this.exclusions;
    }

    public ApplicationGatewayWebApplicationFirewallConfiguration withExclusions(List<ApplicationGatewayFirewallExclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public void validate() {
        if (this.firewallMode() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property firewallMode in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (this.ruleSetType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleSetType in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (this.ruleSetVersion() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleSetVersion in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (this.disabledRuleGroups() != null) {
            this.disabledRuleGroups().forEach(e -> e.validate());
        }
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
    }
}

