/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.AzureFirewallNetworkRuleCollectionPropertiesFormat;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRule;
import com.azure.resourcemanager.network.models.AzureFirewallRCAction;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AzureFirewallNetworkRuleCollection
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFirewallNetworkRuleCollection.class);
    @JsonProperty(value="properties")
    private AzureFirewallNetworkRuleCollectionPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private AzureFirewallNetworkRuleCollectionPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public AzureFirewallNetworkRuleCollection withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public AzureFirewallNetworkRuleCollection withId(String id) {
        super.withId(id);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public AzureFirewallNetworkRuleCollection withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallNetworkRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public AzureFirewallRCAction action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    public AzureFirewallNetworkRuleCollection withAction(AzureFirewallRCAction action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallNetworkRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    public List<AzureFirewallNetworkRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public AzureFirewallNetworkRuleCollection withRules(List<AzureFirewallNetworkRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallNetworkRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

