/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ContainerNetworkInterfaceConfigurationPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerNetworkInterfaceConfiguration
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerNetworkInterfaceConfiguration.class);
    @JsonProperty(value="properties")
    private ContainerNetworkInterfaceConfigurationPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private ContainerNetworkInterfaceConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ContainerNetworkInterfaceConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public ContainerNetworkInterfaceConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public List<IpConfigurationProfileInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public ContainerNetworkInterfaceConfiguration withIpConfigurations(List<IpConfigurationProfileInner> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfaceConfigurationPropertiesFormat();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public List<SubResource> containerNetworkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaces();
    }

    public ContainerNetworkInterfaceConfiguration withContainerNetworkInterfaces(List<SubResource> containerNetworkInterfaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfaceConfigurationPropertiesFormat();
        }
        this.innerProperties().withContainerNetworkInterfaces(containerNetworkInterfaces);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

