/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.ocr;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.contentcensor.EImgType;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import org.json.JSONObject;

public class AipOcr
extends BaseClient {
    public AipOcr(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject basicGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.basicGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject basicGeneralUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicAccurateGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicAccurateGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.basicAccurateGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject general(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject general(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.general(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject generalUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject accurateGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/accurate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject accurateGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.accurateGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject enhancedGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject enhancedGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.enhancedGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject enhancedGeneralUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.webImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject webImageUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject idcard(byte[] image, String idCardSide, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("id_card_side", idCardSide);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/idcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject idcard(String image, String idCardSide, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.idcard(data, idCardSide, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject bankcard(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/bankcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject bankcard(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.bankcard(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject drivingLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/driving_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject drivingLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.drivingLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vehicleLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject plateLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/license_plate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject plateLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.plateLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject businessLicense(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/business_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject businessLicense(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.businessLicense(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject receipt(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject receipt(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.receipt(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject trainTicket(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/train_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject trainTicket(String image, EImgType type, HashMap<String, String> options) {
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/train_ticket", options);
    }

    public JSONObject taxiReceipt(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/taxi_receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject taxiReceipt(String image, EImgType type, HashMap<String, String> options) {
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/taxi_receipt", options);
    }

    public JSONObject form(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/form");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject form(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.form(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognitionAsync(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/request");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableRecognitionAsync(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.tableRecognitionAsync(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableResultGet(String requestId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("request_id", requestId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/get_request_result");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vinCode(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vin_code");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vinCode(String image, EImgType type, HashMap<String, String> options) {
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/vin_code", options);
    }

    public JSONObject quotaInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/quota_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject quotaInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.quotaInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject householdRegister(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/household_register");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject householdRegister(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.householdRegister(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject HKMacauExitentrypermit(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/HK_Macau_exitentrypermit");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject HKMacauExitentrypermit(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.HKMacauExitentrypermit(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject taiwanExitentrypermit(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/taiwan_exitentrypermit");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject taiwanExitentrypermit(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.taiwanExitentrypermit(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject birthCertificate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/birth_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject birthCertificate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.birthCertificate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vehicleInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleCertificate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleCertificate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vehicleCertificate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject invoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject invoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.invoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject airTicket(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/air_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject airTicket(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.airTicket(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject insuranceDocuments(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/insurance_documents");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject insuranceDocuments(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.insuranceDocuments(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vatInvoice(String image, EImgType type, HashMap<String, String> options) {
        if (type == EImgType.PDF) {
            AipRequest request = new AipRequest();
            this.preOperation(request);
            if (options != null) {
                request.addBody(options);
            }
            try {
                byte[] data = Util.readFileByBytes(image);
                String base64Content = Base64Util.encode(data);
                request.addBody("pdf_file", base64Content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice");
            this.postOperation(request);
            return this.requestServer(request);
        }
        return this.ocrByUrlOrFile(image, type, "https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice", options);
    }

    public JSONObject vatInvoice(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vatInvoice(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vatInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject qrcode(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/qrcode");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject qrcode(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.qrcode(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject numbers(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/numbers");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject numbers(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.numbers(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject lottery(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/lottery");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject lottery(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.lottery(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject passport(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/passport");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject passport(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.passport(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject businessCard(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/business_card");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject businessCard(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.businessCard(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject handwriting(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject handwriting(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.handwriting(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject custom(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject custom(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.custom(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject getTableRecognitionJsonResult(String requestId) {
        return this.getTableResultHelper(requestId, "json");
    }

    public JSONObject getTableRecognitionExcelResult(String requestId) {
        return this.getTableResultHelper(requestId, "excel");
    }

    private JSONObject getTableResultHelper(String requestId, String resultType) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("request_id", requestId);
        request.addBody("result_type", resultType);
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/get_request_result");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableRecognizeToJson(String imgPath, long timeoutMiliseconds) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.tableRecognizeToJson(imgData, timeoutMiliseconds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognizeToJson(byte[] imgData, long timeoutMiliseconds) {
        return this.tableRecSyncHelper(imgData, timeoutMiliseconds, "json");
    }

    public JSONObject tableRecognizeToExcelUrl(String imgPath, long timeoutMiliseconds) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.tableRecognizeToExcelUrl(imgData, timeoutMiliseconds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognizeToExcelUrl(byte[] imgData, long timeoutMiliseconds) {
        return this.tableRecSyncHelper(imgData, timeoutMiliseconds, "excel");
    }

    private JSONObject tableRecSyncHelper(byte[] imgData, long timeout, String resultType) {
        JSONObject res = this.tableRecognitionAsync(imgData, null);
        if (res.has("error_code")) {
            return res;
        }
        String reqId = res.getJSONArray("result").getJSONObject(0).getString("request_id");
        long start = Calendar.getInstance().getTimeInMillis();
        long sleepInterval = 2000L;
        long now;
        while ((now = Calendar.getInstance().getTimeInMillis()) - start <= timeout) {
            JSONObject result = this.getTableResultHelper(reqId, resultType);
            if (result.has("error_code")) {
                return result;
            }
            int retCode = result.getJSONObject("result").getInt("ret_code");
            if (retCode == 3) {
                return result;
            }
            try {
                Thread.sleep(sleepInterval);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return AipError.ASYNC_TIMEOUT_ERROR.toJsonResult();
    }

    public JSONObject docAnalysis(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.docAnalysis(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docAnalysis(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject meter(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.meter(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject meter(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/meter");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webimageLoc(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.webimageLoc(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject webimageLoc(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage_loc");
        this.postOperation(request);
        return this.requestServer(request);
    }

    private JSONObject ocrByUrlOrFile(String image, EImgType type, String targetUrl, HashMap<String, String> options) {
        if (type == EImgType.FILE) {
            return this.ocrByFile(image, targetUrl, options);
        }
        return this.ocrByUrl(image, targetUrl, options);
    }

    private JSONObject ocrByUrl(String imageUrl, String targetUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", imageUrl);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(targetUrl);
        this.postOperation(request);
        return this.requestServer(request);
    }

    private JSONObject ocrByFile(String image, String targetUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        try {
            byte[] data = Util.readFileByBytes(image);
            String base64Content = Base64Util.encode(data);
            request.addBody("image", base64Content);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(targetUrl);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject qrcodeUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/qrcode");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docAnalysisUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleInvoiceUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleCertificateUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject householdRegisterUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/household_register");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject handwritingUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject airTicketUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/air_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject invoiceUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject passportUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/passport");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject onlineTaxiItinerary(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/online_taxi_itinerary");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject onlineTaxiItineraryUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/online_taxi_itinerary");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject onlineTaxiItineraryPdf(byte[] pdfFile, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdfFile);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/online_taxi_itinerary");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject weightNote(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/weight_note");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject weightNoteUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/weight_note");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject weightNotePdf(byte[] pdfFile, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdfFile);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/weight_note");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalDetail(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_detail");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalDetailUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_detail");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docAnalysisOffice(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.docAnalysisOffice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docAnalysisOffice(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis_office");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docAnalysisOfficeUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis_office");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docAnalysisOfficePdf(String pdf, int pdfFileNum, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.docAnalysisOfficePdf(data, pdfFileNum, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docAnalysisOfficePdf(byte[] pdf, int pdfFileNum, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        request.addBody("pdf_file_num", pdfFileNum);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_analysis_office");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject seal(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.seal(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject seal(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/seal");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sealUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/seal");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sealPdf(String pdf, int pdfFileNum) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.sealPdf(data, pdfFileNum);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sealPdf(byte[] pdf, int pdfFileNum) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        request.addBody("pdf_file_num", pdfFileNum);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/seal");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiIdcard(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.multiIdcard(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multiIdcard(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multi_idcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiIdcardUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multi_idcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject socialSecurityCard(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.socialSecurityCard(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject socialSecurityCard(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/social_security_card");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject socialSecurityCardUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/social_security_card");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiCardClassify(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.multiCardClassify(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multiCardClassify(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multi_card_classify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiCardClassifyUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multi_card_classify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject mixedMultiVehicle(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.mixedMultiVehicle(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject mixedMultiVehicle(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/mixed_multi_vehicle");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject mixedMultiVehicleUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/mixed_multi_vehicle");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject usedVehicleInvoice(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.usedVehicleInvoice(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject usedVehicleInvoice(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/used_vehicle_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject usedVehicleInvoiceUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/used_vehicle_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleRegistrationCertificate(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vehicleRegistrationCertificate(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleRegistrationCertificate(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_registration_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleRegistrationCertificateUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_registration_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject waybill(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.waybill(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject waybill(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/waybill");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject waybillUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/waybill");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject roadTransportCertificate(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.roadTransportCertificate(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject roadTransportCertificate(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/road_transport_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject roadTransportCertificateUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/road_transport_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject roadTransportCertificatePdf(String pdf, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.roadTransportCertificatePdf(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject roadTransportCertificatePdf(byte[] pdf, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/road_transport_certificate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multipleInvoice(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.multipleInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multipleInvoice(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multipleInvoiceUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multipleInvoicePdf(String pdf, int pdfFileNum, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.multipleInvoicePdf(data, pdfFileNum, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multipleInvoicePdf(byte[] pdf, int pdfFileNum, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        request.addBody("pdf_file_num", pdfFileNum);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vatInvoiceVerification(String invoiceCode, String invoiceNum, String invoiceDate, String invoiceType, String checkCode, String totalAmount) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("invoice_code", invoiceCode);
        request.addBody("invoice_num", invoiceNum);
        request.addBody("invoice_date", invoiceDate);
        request.addBody("invoice_type", invoiceType);
        request.addBody("check_code", checkCode);
        request.addBody("total_amount", totalAmount);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice_verification");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject busTicket(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.busTicket(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject busTicket(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/bus_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject busTicketUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/bus_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tollInvoice(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.tollInvoice(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tollInvoice(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/toll_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tollInvoiceUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/toll_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject ferryTicket(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.ferryTicket(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject ferryTicket(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/ferry_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject ferryTicketUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/ferry_ticket");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject shoppingReceipt(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.shoppingReceipt(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject shoppingReceipt(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/shopping_receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject shoppingReceiptUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/shopping_receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject shoppingReceiptPdf(String pdf, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.shoppingReceiptPdf(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject shoppingReceiptPdf(byte[] pdf, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/shopping_receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalInvoice(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalInvoice(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalInvoice(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalInvoiceUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_invoice");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalStatement(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalStatement(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalStatement(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_statement");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalStatementUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_statement");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalReportDetection(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalReportDetection(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalReportDetection(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_report_detection");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalReportDetectionUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_report_detection");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalRecord(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalRecord(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalRecord(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_record");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalRecordUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_record");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalSummary(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalSummary(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalSummary(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_summary");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalSummaryUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_summary");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalReciptsClassify(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalReciptsClassify(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalReciptsClassify(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_recipts_classify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalReciptsClassifyUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_recipts_classify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject formula(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.formula(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject formula(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/formula");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject formulaUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/formula");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject travelCard(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.travelCard(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject travelCard(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/travel_card");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject facade(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.facade(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject facade(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/facade");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject healthCode(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.healthCode(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject healthCode(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/health_code");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject covidTest(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.covidTest(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject covidTest(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/covid_test");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject intelligentOcr(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.intelligentOcr(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject intelligentOcr(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/intelligent_ocr");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject intelligentOcrUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/intelligent_ocr");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject finance(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.finance(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject finance(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise/finance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject financeUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise/finance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject financePdf(String pdf, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.financePdf(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject financePdf(byte[] pdf, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise/finance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject table(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.table(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject table(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/table");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/table");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tablePdf(String pdf, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.tablePdf(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tablePdf(byte[] pdf, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/table");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject removeHandwriting(String image) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.removeHandwriting(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject removeHandwriting(byte[] image) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/remove_handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject removeHandwritingUrl(String url) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/remove_handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject removeHandwritingPdf(String pdf) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.removeHandwritingPdf(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject removeHandwritingPdf(byte[] pdf) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/remove_handwriting");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docCropEnhance(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.docCropEnhance(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docCropEnhance(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_crop_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docCropEnhanceUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_crop_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject docCropEnhancePdf(String pdf, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(pdf);
            return this.docCropEnhancePdf(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject docCropEnhancePdf(byte[] pdf, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(pdf);
        request.addBody("pdf_file", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/doc_crop_enhance");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalPrescription(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalPrescription(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalPrescription(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_prescription");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalPrescriptionUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_prescription");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalOutpatient(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalOutpatient(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalOutpatient(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_outpatient");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalOutpatientUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_outpatient");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalSummaryDiagnosis(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.medicalSummaryDiagnosis(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject medicalSummaryDiagnosis(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_summary_diagnosis");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject medicalSummaryDiagnosisUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/medical_summary_diagnosis");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject healthReport(String image, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.healthReport(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject healthReport(byte[] image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/health_report");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject healthReportUrl(String url, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/health_report");
        this.postOperation(request);
        return this.requestServer(request);
    }
}

