/*
 * Decompiled with CFR 0.152.
 */
package com.byteblogs.helloblog.endpoint;

import com.byteblogs.helloblog.dto.HttpResult;
import com.byteblogs.helloblog.integration.ByteBlogsClient;
import com.byteblogs.helloblog.integration.dto.EmailDTO;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/byteblogs"})
public class ByteBlogsEndPoint {
    @Autowired
    private ByteBlogsClient byteBlogsClient;

    @GetMapping(value={"/posts"})
    public HttpResult getPostsList(@NotNull @RequestParam(value="pagingQuery.pageIndex", required=false) Integer pageIndex, @NotNull @RequestParam(value="pagingQuery.pageSize", required=false) Integer pageSize) {
        return this.byteBlogsClient.getPostsList(pageIndex, pageSize);
    }

    @PostMapping(value={"/email/v1/send"})
    public HttpResult sendRegisterEmail(@RequestBody EmailDTO emailDTO) {
        return this.byteBlogsClient.sendRegisterEmail(emailDTO);
    }

    @GetMapping(value={"/user/v1/count"})
    public HttpResult countPerson() {
        return this.byteBlogsClient.countPerson();
    }

    @GetMapping(value={"/user-views/v1/chart"})
    public HttpResult getViewsChart() {
        return this.byteBlogsClient.getViewsChart();
    }
}

