/*
 * Decompiled with CFR 0.152.
 */
package com.byteblogs.helloblog.integration;

import com.byteblogs.helloblog.dto.HttpResult;
import com.byteblogs.helloblog.integration.dto.EmailDTO;
import com.byteblogs.helloblog.integration.dto.PostsDTO;
import com.byteblogs.helloblog.integration.dto.UserDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="byteBlogsClient", url="https://www.byteblogs.com/api/blog")
public interface ByteBlogsClient {
    @GetMapping(value={"/posts/posts/list"})
    public HttpResult getPostsList(@RequestParam(value="pagingQuery.pageIndex", required=false) Integer var1, @RequestParam(value="pagingQuery.pageSize", required=false) Integer var2);

    @GetMapping(value={"/aggregation/user/v1/count"})
    public HttpResult countPerson();

    @GetMapping(value={"/aggregation/user/v1/chart"})
    public HttpResult getViewsChart();

    @GetMapping(value={"/oauth/github-authorize/v1/get"})
    public HttpResult githubAuthorize(@RequestParam(value="state", required=false) String var1);

    @PostMapping(value={"/email/hello-blog/v1/send"})
    public HttpResult sendRegisterEmail(@RequestBody EmailDTO var1);

    @PostMapping(value={"/authentication/hello-blog/v1/register"})
    public HttpResult registerUsers(@RequestBody UserDTO var1);

    @PostMapping(value={"/posts/hello-blog/v1/add"})
    public HttpResult syncPosts(@RequestBody PostsDTO var1);
}

