/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.dataset;

import com.coze.openapi.api.DocumentAPI;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageNumBasedPaginator;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.client.dataset.document.CreateDocumentReq;
import com.coze.openapi.client.dataset.document.CreateDocumentResp;
import com.coze.openapi.client.dataset.document.DeleteDocumentReq;
import com.coze.openapi.client.dataset.document.DeleteDocumentResp;
import com.coze.openapi.client.dataset.document.ListDocumentReq;
import com.coze.openapi.client.dataset.document.ListDocumentResp;
import com.coze.openapi.client.dataset.document.UpdateDocumentReq;
import com.coze.openapi.client.dataset.document.UpdateDocumentResp;
import com.coze.openapi.client.dataset.document.model.Document;
import com.coze.openapi.service.utils.Utils;
import org.jetbrains.annotations.NotNull;

public class DocumentService {
    private final DocumentAPI api;

    public DocumentService(DocumentAPI api) {
        this.api = api;
    }

    public CreateDocumentResp create(CreateDocumentReq req) {
        return Utils.execute(this.api.create(req, req));
    }

    public UpdateDocumentResp update(UpdateDocumentReq req) {
        String logID = Utils.execute(this.api.update(req, req)).getLogID();
        return ((UpdateDocumentResp.UpdateDocumentRespBuilder)UpdateDocumentResp.builder().logID(logID)).build();
    }

    public DeleteDocumentResp delete(DeleteDocumentReq req) {
        String logID = Utils.execute(this.api.delete(req, req)).getLogID();
        return ((DeleteDocumentResp.DeleteDocumentRespBuilder)DeleteDocumentResp.builder().logID(logID)).build();
    }

    public PageResp<Document> list(@NotNull ListDocumentReq req) {
        if (req == null || req.getDatasetID() == null) {
            throw new IllegalArgumentException("req is required");
        }
        Integer pageNum = req.getPage();
        Integer pageSize = req.getSize();
        PageFetcher pageFetcher = request -> {
            ListDocumentResp resp = Utils.execute(this.api.list(ListDocumentReq.of(req.getDatasetID(), request.getPageNum(), request.getPageSize()), req));
            return PageResponse.builder().hasMore(resp.getDocumentInfos().size() == request.getPageSize().intValue()).data(resp.getDocumentInfos()).pageNum(request.getPageNum()).logID(resp.getLogID()).pageSize(request.getPageSize()).total(resp.getTotal().intValue()).build();
        };
        PageNumBasedPaginator paginator = new PageNumBasedPaginator(pageFetcher, pageSize);
        PageRequest initialRequest = PageRequest.builder().pageNum(pageNum).pageSize(pageSize).build();
        PageResponse currentPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().total(currentPage.getTotal()).items(currentPage.getData()).iterator(paginator).hasMore(currentPage.isHasMore()).logID(currentPage.getLogID()).build();
    }
}

