/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.asynccollector;

import com.datarangers.asynccollector.CollectorQueue;
import com.datarangers.message.Message;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

public class CollectorContainer {
    private CollectorQueue messageQueue;
    public static final ConcurrentHashMap<String, ConcurrentHashMap<String, LongAdder>> SEND_HISTORY = new ConcurrentHashMap();

    public CollectorContainer(CollectorQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void produce(Message message) throws InterruptedException {
        this.messageQueue.put(message);
    }

    public boolean offer(Message message, long timeout) throws InterruptedException {
        return this.messageQueue.offer(message, timeout);
    }

    private List<Message> handleMessage(List<Message> messages) throws InterruptedException {
        if (messages == null) {
            return null;
        }
        messages.forEach(message -> this.doHandleMessage((Message)message));
        return messages;
    }

    public List<Message> consume() throws InterruptedException {
        return this.handleMessage(this.messageQueue.take());
    }

    public List<Message> consume(int waitTimeMs) throws InterruptedException {
        return this.handleMessage(this.messageQueue.poll(waitTimeMs));
    }

    public List<Message> consume(int size, int waitTimeMs) throws InterruptedException {
        return this.handleMessage(this.messageQueue.poll(size, waitTimeMs));
    }

    public int size() {
        return this.messageQueue.size();
    }

    public CollectorQueue getMessageQueue() {
        return this.messageQueue;
    }

    public Message handleMessage(Message message) {
        if (message == null) {
            return null;
        }
        this.doHandleMessage(message);
        return message;
    }

    private void doHandleMessage(Message message) {
        message.getAppMessage().getEvents().forEach(event -> {
            int appId = message.getAppMessage().getAppId();
            String eventName = event.getEvent();
            String date = event.getDatetime().substring(0, 13);
            if (!SEND_HISTORY.containsKey(date)) {
                SEND_HISTORY.put(date, new ConcurrentHashMap());
            }
            String key = appId + "-" + eventName;
            ConcurrentHashMap<String, LongAdder> map = SEND_HISTORY.get(date);
            if (!map.containsKey(key)) {
                map.put(key, new LongAdder());
            }
            map.get(key).increment();
        });
    }
}

