/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.asynccollector;

import com.datarangers.asynccollector.CollectorQueue;
import com.datarangers.message.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class RangersCollectorQueue
implements CollectorQueue {
    private static volatile CollectorQueue instance = null;
    private BlockingQueue<Message> queue;

    private RangersCollectorQueue(int queueLength) {
        this.queue = new LinkedBlockingQueue<Message>(queueLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectorQueue getInstance(int queueLength) {
        if (instance != null) return instance;
        Class<RangersCollectorQueue> clazz = RangersCollectorQueue.class;
        synchronized (RangersCollectorQueue.class) {
            if (instance != null) return instance;
            instance = new RangersCollectorQueue(queueLength);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectorQueue getInstance(CollectorQueue _queue) {
        if (instance != null) return instance;
        Class<RangersCollectorQueue> clazz = RangersCollectorQueue.class;
        synchronized (RangersCollectorQueue.class) {
            if (instance != null) return instance;
            instance = _queue;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public List<Message> take() throws InterruptedException {
        return Collections.singletonList(this.queue.take());
    }

    @Override
    public List<Message> poll(int waitTimeMs) throws InterruptedException {
        Message msg = this.queue.poll(waitTimeMs, TimeUnit.MILLISECONDS);
        if (msg != null) {
            return Collections.singletonList(msg);
        }
        return null;
    }

    @Override
    public List<Message> poll(int size, int waitTimeMs) throws InterruptedException {
        ArrayList<Message> messages = new ArrayList<Message>();
        Message msg = this.queue.poll(waitTimeMs, TimeUnit.MILLISECONDS);
        if (msg != null) {
            messages.add(msg);
        }
        while (messages.size() < size && (msg = this.queue.poll(waitTimeMs, TimeUnit.MILLISECONDS)) != null) {
            messages.add(msg);
        }
        return messages;
    }

    @Override
    public void put(Message t) throws InterruptedException {
        this.queue.put(t);
    }

    @Override
    public boolean offer(Message t, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            return this.queue.offer(t, timeout, TimeUnit.MILLISECONDS);
        }
        return this.queue.offer(t);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Message poll() {
        return (Message)this.queue.poll();
    }
}

