/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.config;

import com.datarangers.asynccollector.CollectorQueue;
import com.datarangers.config.HttpConfig;
import com.datarangers.config.KafkaConfig;
import com.datarangers.config.OpenapiConfig;
import com.datarangers.config.SdkMode;
import com.datarangers.config.VerifyConfig;
import com.datarangers.message.MessageEnv;
import com.datarangers.sender.Callback;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.HttpClient;

public class DataRangersSDKConfigProperties {
    public boolean enable = true;
    public Map<String, String> headers;
    public String domain;
    private String path;
    private int threadCount = 20;
    @Deprecated
    public int httpTimeout = 10000;
    public String timeZone = "+8";
    public ZoneOffset timeOffset = null;
    @Deprecated
    public boolean save = false;
    public int queueSize = 10240;
    private boolean sendBatch = false;
    private int batchSize = 20;
    private int waitTimeMs = 100;
    public String eventSavePath = "logs/";
    public List<String> eventFilePaths;
    public String eventSaveName = "datarangers.log";
    public int eventSaveMaxFileSize = 100;
    private boolean eventCountFileDisable = false;
    public int eventSaveMaxDays = -1;
    public CollectorQueue userQueue;
    private HttpConfig httpConfig = new HttpConfig();
    private HttpClient customHttpClient;
    private Map<Integer, String> appKeys = new HashMap<Integer, String>();
    private String env = "privatization";
    private List<String> SAAS_DOMAIN_URLS = Arrays.asList("https://mcs.ctobsnssdk.com", "https://mcs.tobsnssdk.com");
    private List<String> SAAS_NATIVE_DOMAIN_URLS = Arrays.asList("https://gator.volces.com");
    private OpenapiConfig openapiConfig = new OpenapiConfig();
    private Callback callback;
    private boolean sync;
    private SdkMode mode;
    private KafkaConfig kafka;
    private VerifyConfig verify = new VerifyConfig();

    public VerifyConfig getVerify() {
        return this.verify;
    }

    public void setVerify(VerifyConfig verify) {
        this.verify = verify;
    }

    public boolean isSendBatch() {
        return this.sendBatch;
    }

    public void setSendBatch(boolean sendBatch) {
        this.sendBatch = sendBatch;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getWaitTimeMs() {
        return this.waitTimeMs;
    }

    public void setWaitTimeMs(int waitTimeMs) {
        this.waitTimeMs = waitTimeMs;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public KafkaConfig getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaConfig kafka) {
        this.kafka = kafka;
    }

    public SdkMode getMode() {
        if (this.mode != null) {
            return this.mode;
        }
        if (this.isSave()) {
            return SdkMode.FILE;
        }
        return SdkMode.HTTP;
    }

    public void setMode(SdkMode mode) {
        this.mode = mode;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public DataRangersSDKConfigProperties setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
        return this;
    }

    public List<String> getEventFilePaths() {
        if (this.eventFilePaths == null) {
            this.eventFilePaths = new ArrayList<String>();
            this.eventFilePaths.add(this.eventSavePath);
        }
        return this.eventFilePaths;
    }

    public int getEventSaveMaxDays() {
        return this.eventSaveMaxDays;
    }

    public DataRangersSDKConfigProperties setEventSaveMaxDays(int eventSaveMaxDays) {
        this.eventSaveMaxDays = eventSaveMaxDays;
        return this;
    }

    public DataRangersSDKConfigProperties setEventFilePaths(List<String> eventFilePaths) {
        this.eventFilePaths = eventFilePaths;
        return this;
    }

    public String getEventSavePath() {
        return this.eventSavePath;
    }

    public DataRangersSDKConfigProperties setEventSavePath(String eventSavePath) {
        this.eventSavePath = eventSavePath;
        return this;
    }

    public String getEventSaveName() {
        return this.eventSaveName;
    }

    public DataRangersSDKConfigProperties setEventSaveName(String eventSaveName) {
        this.eventSaveName = eventSaveName;
        return this;
    }

    public int getEventSaveMaxFileSize() {
        return this.eventSaveMaxFileSize;
    }

    public DataRangersSDKConfigProperties setEventSaveMaxFileSize(int eventSaveMaxFileSize) {
        this.eventSaveMaxFileSize = eventSaveMaxFileSize;
        return this;
    }

    public boolean isEventCountFileDisable() {
        return this.eventCountFileDisable;
    }

    public void setEventCountFileDisable(boolean eventCountFileDisable) {
        this.eventCountFileDisable = eventCountFileDisable;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ZoneOffset getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(ZoneOffset timeOffset) {
        this.timeOffset = timeOffset;
    }

    @Deprecated
    public boolean isSave() {
        return this.save;
    }

    @Deprecated
    public void setSave(boolean save) {
        this.save = save;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeOffset = ZoneOffset.of(timeZone);
        this.timeZone = timeZone;
    }

    public CollectorQueue getUserQueue() {
        return this.userQueue;
    }

    public DataRangersSDKConfigProperties setUserQueue(CollectorQueue userQueue) {
        this.userQueue = userQueue;
        return this;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public HttpClient getCustomHttpClient() {
        return this.customHttpClient;
    }

    public void setCustomHttpClient(HttpClient customHttpClient) {
        this.customHttpClient = customHttpClient;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public OpenapiConfig getOpenapiConfig() {
        return this.openapiConfig;
    }

    public void setOpenapiConfig(OpenapiConfig openapiConfig) {
        this.openapiConfig = openapiConfig;
    }

    public MessageEnv getMessageEnv() {
        if ("saas".equalsIgnoreCase(this.getEnv()) || this.SAAS_DOMAIN_URLS.contains(this.getDomain())) {
            return MessageEnv.SAAS;
        }
        if ("saas_native".equalsIgnoreCase(this.getEnv()) || this.SAAS_NATIVE_DOMAIN_URLS.contains(this.getDomain())) {
            return MessageEnv.SAAS_NATIVE;
        }
        return MessageEnv.PRIVATIZATION;
    }

    public Map<Integer, String> getAppKeys() {
        return this.appKeys;
    }

    public void setAppKeys(Map<Integer, String> appKeys) {
        this.appKeys = appKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("enable: %s \r\n", this.enable));
        sb.append(String.format("env: %s \r\n", new Object[]{this.getMessageEnv()}));
        sb.append(String.format("sync: %s \r\n", this.sync));
        sb.append(String.format("sdkMode: %s \r\n", new Object[]{this.mode}));
        sb.append(String.format("domain: %s \r\n", this.domain));
        sb.append(String.format("headers: %s \r\n", this.headers));
        sb.append(String.format("threadCount: %s \r\n", this.threadCount));
        sb.append(String.format("queueSize: %s \r\n", this.queueSize));
        sb.append(String.format("sendBatch: %s \r\n", this.sendBatch));
        sb.append(String.format("batchSize: %s \r\n", this.batchSize));
        sb.append(String.format("waitTimeMs: %s \r\n", this.waitTimeMs));
        sb.append(String.format("httpConfig: %s \r\n", this.httpConfig));
        sb.append(String.format("eventSavePath: %s \r\n", this.eventSavePath));
        sb.append(String.format("eventSaveName: %s \r\n", this.eventSaveName));
        sb.append(String.format("eventFilePaths: %s \r\n", this.eventFilePaths));
        sb.append(String.format("eventSaveMaxFileSize: %s \r\n", this.eventSaveMaxFileSize));
        sb.append(String.format("eventSaveMaxDays: %s \r\n", this.eventSaveMaxDays));
        sb.append(String.format("eventCountFileDisable: %s \r\n", this.eventCountFileDisable));
        sb.append(String.format("verify: %s\r\n", this.verify));
        sb.append(String.format("openapiConfig: %s \r\n", this.openapiConfig));
        sb.append(String.format("kafka: %s", this.kafka));
        return sb.toString();
    }
}

