/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.event;

import com.datarangers.config.Constants;
import com.datarangers.event.Event;
import com.datarangers.event.Item;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventV3
implements Event,
Serializable {
    private String event;
    private Map<String, Object> params = new HashMap<String, Object>();
    private String sessionId;
    private Long localTimeMs = System.currentTimeMillis();
    @JsonProperty(value="datetime")
    private String datetime = LocalDateTime.now().format(Constants.FULL_DAY);
    private Integer eventId;
    @JsonIgnore
    private String userId;
    private Long teaEventIndex;
    @JsonProperty(value="ab_sdk_version")
    private String abSdkVersion;
    @JsonIgnore
    private Map<String, List<Object>> itemParams = new HashMap<String, List<Object>>();

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public EventV3 setEvent(String event) {
        this.event = event;
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public EventV3 setParams(Map<String, Object> params) {
        if (params != null) {
            params.forEach((key, value) -> {
                if (value instanceof Item) {
                    HashMap<String, String> itemMap = new HashMap<String, String>();
                    itemMap.put("id", ((Item)value).getItemId());
                    String name = ((Item)value).getItemName();
                    List list = this.itemParams.getOrDefault(name, new ArrayList());
                    list.add(itemMap);
                    this.itemParams.put(name, list);
                } else {
                    this.params.put((String)key, value);
                }
            });
            if (this.itemParams.size() > 0) {
                ArrayList itemP = new ArrayList();
                this.itemParams.forEach((key, value) -> {
                    HashMap<String, List> res = new HashMap<String, List>();
                    res.put((String)key, (List)value);
                    itemP.add(res);
                });
                this.params.put("__items", itemP);
            }
        }
        return this;
    }

    @Override
    public Event addParams(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public String key() {
        return this.datetime.substring(0, 13) + "-" + this.event;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public EventV3 setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public Long getLocalTimeMs() {
        return this.localTimeMs;
    }

    @Override
    public EventV3 setLocalTimeMs(Long localTimeMs) {
        this.localTimeMs = localTimeMs;
        this.datetime = LocalDateTime.ofInstant(Instant.ofEpochMilli(localTimeMs), Constants.TIME_ZONE_ID).format(Constants.FULL_DAY);
        return this;
    }

    @Override
    public String getDatetime() {
        return this.datetime;
    }

    public EventV3 setDatetime(String datetime) {
        this.datetime = datetime;
        return this;
    }

    public Integer getEventId() {
        return this.eventId;
    }

    public EventV3 setEventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public EventV3 setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public Long getTeaEventIndex() {
        return this.teaEventIndex;
    }

    public EventV3 setTeaEventIndex(Long teaEventIndex) {
        this.teaEventIndex = teaEventIndex;
        return this;
    }

    public String getAbSdkVersion() {
        return this.abSdkVersion;
    }

    @Override
    public EventV3 setAbSdkVersion(String abSdkVersion) {
        this.abSdkVersion = abSdkVersion;
        return this;
    }
}

