/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.message;

import com.datarangers.event.Event;
import com.datarangers.event.Header;
import com.datarangers.event.HeaderV3;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class AppMessage
implements Cloneable {
    @JsonProperty(value="app_type")
    private String appType;
    @JsonProperty(value="_format_name")
    private String formatName = "datarangers_svc_app_log_v3_server_sdk_1.2.7";
    @JsonProperty(value="client_ip")
    private String clientIp;
    @JsonProperty(value="trace_id")
    private String traceId;
    @JsonProperty(value="app_id")
    private Integer appId;
    @JsonProperty(value="header")
    private HeaderV3 header;
    @JsonProperty(value="user_unique_id")
    private String userUniqueId;
    @JsonProperty(value="event_v3")
    private List<Event> events = new ArrayList<Event>();

    public HeaderV3 getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = (HeaderV3)header;
        this.setAppId(header.getAppId());
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public void addEvents(List<Event> events) {
        this.events.addAll(events);
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void merge() {
        if (this.header.getDeviceId() != null && this.header.getDeviceId() < 0L) {
            this.header.setDeviceId(1L);
        }
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public Integer getAppId() {
        return this.appId;
    }

    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getUserUniqueId() {
        return this.userUniqueId;
    }

    public void setUserUniqueId(String userUniqueId) {
        this.userUniqueId = userUniqueId;
    }

    public AppMessage clone() {
        AppMessage clone;
        try {
            clone = (AppMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.header != null) {
            clone.setHeader(this.header.clone());
        }
        ArrayList<Event> cloneEvents = new ArrayList<Event>();
        cloneEvents.addAll(this.events);
        clone.setEvents(cloneEvents);
        return clone;
    }
}

