/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.sender;

import com.datarangers.message.Message;
import com.datarangers.message.MessageEnv;
import com.datarangers.message.MessageType;
import com.datarangers.sender.MessageSender;
import com.datarangers.sender.PrivatizationMessageSender;
import com.datarangers.sender.saas.SaasItemAppMessageSender;
import com.datarangers.sender.saas.SaasProfileAppMessageSender;
import com.datarangers.sender.saas.SaasServerAppMessageSender;
import com.datarangers.sender.saasnative.SaasNativeMessageSender;

public class MessageSenderFactory {
    private MessageSenderFactory() {
    }

    public static MessageSender getMessageSender(Message message) {
        MessageEnv messageEnv = message.getMessageEnv();
        if (MessageEnv.PRIVATIZATION == messageEnv) {
            return new PrivatizationMessageSender();
        }
        if (MessageEnv.SAAS_NATIVE == messageEnv) {
            return new SaasNativeMessageSender();
        }
        MessageType messageType = message.getMessageType();
        switch (messageType) {
            case EVENT: {
                return new SaasServerAppMessageSender();
            }
            case ITEM: {
                return new SaasItemAppMessageSender();
            }
            case PROFILE: {
                return new SaasProfileAppMessageSender();
            }
        }
        throw new IllegalArgumentException("Not support message: " + (Object)((Object)messageType));
    }
}

