/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.sender.saas;

import com.datarangers.config.DataRangersSDKConfigProperties;
import com.datarangers.config.EventConfig;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.message.Message;
import com.datarangers.message.saas.SaasServerAppMessage;
import com.datarangers.sender.MessageSender;
import com.datarangers.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;

public class SaasServerAppMessageSender
implements MessageSender {
    private static final String path = "/v2/event/json";

    @Override
    public void send(Message message, DataRangersSDKConfigProperties sdkConfigProperties) {
        SaasServerAppMessage sendMessage = new SaasServerAppMessage(message);
        String url = sdkConfigProperties.getDomain() + this.getPath(sdkConfigProperties);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(EventConfig.SEND_HEADER);
        Integer appId = message.getAppMessage().getAppId();
        Map<Integer, String> appKeys = sdkConfigProperties.getAppKeys();
        String appKey = appKeys.get(appId);
        if (appKey == null) {
            throw new IllegalArgumentException("App key cannot be empty. app_id: " + appId);
        }
        headers.put("X-MCS-AppKey", appKey);
        HttpUtils.post(url, RangersJSONConfig.getInstance().toJson(sendMessage), headers);
    }

    protected String getPath(DataRangersSDKConfigProperties sdkConfigProperties) {
        String domainPath = sdkConfigProperties.getPath();
        if (domainPath == null || domainPath.trim().length() == 0) {
            return path;
        }
        if (!domainPath.startsWith("/")) {
            domainPath = "/" + domainPath;
        }
        return domainPath;
    }
}

