/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.event;

import com.datarangers.config.Constants;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.event.EventV3;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;

public class SaasServerEvent {
    private String event;
    private String params;
    private String sessionId;
    private Long localTimeMs = System.currentTimeMillis();
    @JsonProperty(value="datetime")
    private String datetime = LocalDateTime.now().format(Constants.FULL_DAY);
    private Long teaEventIndex;
    @JsonProperty(value="ab_sdk_version")
    private String abSdkVersion;

    public SaasServerEvent() {
    }

    public SaasServerEvent(EventV3 eventV3) {
        this.setEvent(eventV3.getEvent());
        this.setSessionId(eventV3.getSessionId());
        this.setLocalTimeMs(eventV3.getLocalTimeMs());
        this.setDatetime(eventV3.getDatetime());
        this.setAbSdkVersion(eventV3.getAbSdkVersion());
        this.setTeaEventIndex(eventV3.getTeaEventIndex());
        this.setParams(RangersJSONConfig.getInstance().toJson(eventV3.getParams()));
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Long getLocalTimeMs() {
        return this.localTimeMs;
    }

    public void setLocalTimeMs(Long localTimeMs) {
        this.localTimeMs = localTimeMs;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getTeaEventIndex() {
        return this.teaEventIndex;
    }

    public void setTeaEventIndex(Long teaEventIndex) {
        this.teaEventIndex = teaEventIndex;
    }

    public String getAbSdkVersion() {
        return this.abSdkVersion;
    }

    public void setAbSdkVersion(String abSdkVersion) {
        this.abSdkVersion = abSdkVersion;
    }
}

