/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.logger;

import com.datarangers.config.Constants;
import com.datarangers.logger.RangersFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class RangersLoggerWriter
implements RangersFileWriter {
    private final String targetName;
    private final String targetPrefix;
    private final String fullTarget;
    private File output;
    private FileOutputStream stream;
    private int count;
    private int maxSize;
    private String currentName;
    private int currentIndex = 0;
    private volatile int checkCount = 0;
    private static final Map<String, RangersLoggerWriter> instance = new HashMap<String, RangersLoggerWriter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RangersLoggerWriter getInstance(String targetPrefix, String targetName, int maxSize) {
        Map<String, RangersLoggerWriter> map = instance;
        synchronized (map) {
            String key = targetPrefix + "/" + targetName;
            if (!instance.containsKey(key)) {
                instance.put(key, new RangersLoggerWriter(targetPrefix, targetName, maxSize));
            }
            RangersLoggerWriter writer = instance.get(key);
            ++writer.count;
            return writer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstance(RangersLoggerWriter writer) {
        Map<String, RangersLoggerWriter> map = instance;
        synchronized (map) {
            --writer.count;
            if (writer.count == 0) {
                instance.remove(writer.targetName);
                writer.close();
            }
        }
    }

    private void changeOutputStream() {
        if (this.output.exists() && this.output.length() / 1024L / 1024L > (long)this.maxSize) {
            String currentHour = this.targetName + "." + LocalDateTime.now().format(Constants.FULL_HOUR);
            if (currentHour.equals(this.currentName)) {
                if (!this.output.renameTo(new File(this.targetPrefix + "/" + currentHour + "." + this.currentIndex))) {
                    throw new RuntimeException("rename error![" + this.output.getName() + "]");
                }
                ++this.currentIndex;
                this.output = new File(this.fullTarget);
                try {
                    this.stream.close();
                    this.stream = new FileOutputStream(this.output, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                if (!this.output.renameTo(new File(this.targetPrefix + "/" + this.currentName + "." + this.currentIndex))) {
                    throw new RuntimeException("rename error![" + this.output.getName() + "]");
                }
                this.output = new File(this.fullTarget);
                this.currentName = currentHour;
                this.currentIndex = 0;
                try {
                    this.stream.close();
                    this.stream = new FileOutputStream(this.output, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.checkCount = 0;
        }
    }

    public RangersLoggerWriter(String targetPrefix, String targetName, int maxSize) {
        this.targetName = targetName;
        this.targetPrefix = targetPrefix;
        File parent = new File(targetPrefix);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.currentIndex = this.setCurrentIndex();
        ++this.currentIndex;
        this.fullTarget = this.targetPrefix + "/" + this.targetName;
        this.output = new File(this.fullTarget);
        this.currentName = targetName + "." + LocalDateTime.now().format(Constants.FULL_HOUR);
        try {
            this.stream = new FileOutputStream(this.output, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.maxSize = maxSize;
        this.changeOutputStream();
    }

    public RangersLoggerWriter(String targetPrefix, String targetName) {
        this(targetPrefix, targetName, 0xC800000);
    }

    private int setCurrentIndex() {
        String current = LocalDateTime.now().format(Constants.FULL_HOUR);
        String full = this.targetName + "." + current + ".";
        int number = 0;
        for (File f : new File(this.targetPrefix).listFiles()) {
            if (!f.getName().contains(full)) continue;
            String arr = f.getName().replace(full, "");
            try {
                number = Math.max(number, Integer.valueOf(arr));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return number;
    }

    @Override
    public boolean valid(String targetName) {
        return this.targetName.equals(targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(String message) {
        if (message == null) {
            return false;
        }
        FileLock lock = null;
        try {
            FileChannel channel = this.stream.getChannel();
            lock = channel.lock(0L, Integer.MAX_VALUE, false);
            this.stream.write(message.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ++this.checkCount;
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.checkCount > 10000) {
            FileOutputStream fileOutputStream = this.stream;
            synchronized (fileOutputStream) {
                this.changeOutputStream();
            }
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close output stream", e);
        }
    }
}

