/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.logger;

import com.datarangers.logger.RangersLoggerWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RangersLoggerWriterPool {
    private static RangersLoggerWriterPool POOL = null;
    private static final List<RangersLoggerWriter> WRITERS_POOL = new ArrayList<RangersLoggerWriter>();
    private int size = 0;
    private int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstance(List<String> targetPrefixes, String targetNames, int maxSize) {
        List<RangersLoggerWriter> list = WRITERS_POOL;
        synchronized (list) {
            if (WRITERS_POOL.size() == 0) {
                HashSet<String> prefixSet = new HashSet<String>(targetPrefixes);
                for (String prefix : prefixSet) {
                    WRITERS_POOL.add(RangersLoggerWriter.getInstance(prefix, targetNames, maxSize));
                }
                this.size = WRITERS_POOL.size();
            }
        }
    }

    private RangersLoggerWriterPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangersLoggerWriterPool getInstance(List<String> targetPrefixes, String targetNames, int maxSize) {
        if (POOL != null) return POOL;
        Class<RangersLoggerWriterPool> clazz = RangersLoggerWriterPool.class;
        synchronized (RangersLoggerWriterPool.class) {
            if (POOL != null) return POOL;
            POOL = new RangersLoggerWriterPool();
            POOL.setInstance(targetPrefixes, targetNames, maxSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return POOL;
        }
    }

    public RangersLoggerWriter getWriter() {
        if (WRITERS_POOL.size() == 1) {
            return this.getOneWriter();
        }
        if (WRITERS_POOL.size() > 0) {
            this.count = (this.count + 1) % WRITERS_POOL.size();
            return WRITERS_POOL.get(this.count);
        }
        return null;
    }

    public RangersLoggerWriter getWriter(String uuid) {
        if (WRITERS_POOL.size() == 1) {
            return this.getOneWriter();
        }
        if (WRITERS_POOL.size() > 0) {
            if (uuid == null) {
                return WRITERS_POOL.get(0);
            }
            return WRITERS_POOL.get(Math.abs(uuid.hashCode()) % this.size);
        }
        return null;
    }

    public RangersLoggerWriter getOneWriter() {
        return WRITERS_POOL.get(0);
    }
}

