/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.sender;

import com.datarangers.config.RangersJSONConfig;
import com.datarangers.config.VerifyConfig;
import com.datarangers.message.Message;
import com.datarangers.message.MessageEnv;
import com.datarangers.message.MessageType;
import com.datarangers.message.saas.DefaultSaasServerAppMessage;
import com.datarangers.util.HttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySender {
    public static final Logger logger = LoggerFactory.getLogger(VerifySender.class);
    private static final String QUERY_USER_ID = "user_id";
    private static final String QUERY_VALID_TIME = "valid_time";
    private VerifyConfig verify;
    private long validTime;
    private String verifyUserId;
    private boolean isValid;

    public VerifySender(VerifyConfig verify) {
        this.verify = verify;
        this.parseUrl();
    }

    public void send(Message message) {
        if (!this.isValid) {
            return;
        }
        if (System.currentTimeMillis() >= this.validTime) {
            return;
        }
        if (!this.verifyUserId.equals(message.getAppMessage().getUserUniqueId())) {
            return;
        }
        this.doSend(message);
    }

    private void doSend(Message message) {
        MessageEnv messageEnv = message.getMessageEnv();
        switch (messageEnv) {
            case SAAS: {
                this.verifySaas(message);
                break;
            }
            case SAAS_NATIVE: {
                this.verifySaasNative(message);
                break;
            }
            case PRIVATIZATION: {
                this.verifyPrivatization(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Verify not support message env: " + (Object)((Object)messageEnv));
            }
        }
    }

    private void verifySaas(Message message) {
        MessageType messageType = message.getMessageType();
        if (MessageType.EVENT != messageType) {
            System.out.println("Verify Not support messageType: " + (Object)((Object)messageType));
            logger.warn("Verify Not support messageType: " + (Object)((Object)messageType));
            return;
        }
        DefaultSaasServerAppMessage sendMessage = new DefaultSaasServerAppMessage(message);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.request("POST", this.verify.getUrl(), RangersJSONConfig.getInstance().toJson(sendMessage), headers);
    }

    private void verifySaasNative(Message message) {
        DefaultSaasServerAppMessage sendMessage = new DefaultSaasServerAppMessage(message);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.request("POST", this.verify.getUrl(), RangersJSONConfig.getInstance().toJson(sendMessage), headers);
    }

    private void verifyPrivatization(Message message) {
        DefaultSaasServerAppMessage sendMessage = new DefaultSaasServerAppMessage(message);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.request("POST", this.verify.getUrl(), RangersJSONConfig.getInstance().toJson(sendMessage), headers);
    }

    private void parseUrl() {
        if (this.verify == null || this.verify.getUrl() == null || this.verify.getUrl().length() == 0) {
            return;
        }
        try {
            Map<String, String> params = VerifySender.splitQuery(new URL(this.verify.getUrl()));
            String validTimeStr = params.get(QUERY_VALID_TIME);
            if (validTimeStr == null || validTimeStr.length() == 0) {
                logger.warn("{} is not exist", (Object)QUERY_VALID_TIME);
                return;
            }
            this.validTime = Long.valueOf(new String(Base64.getDecoder().decode(validTimeStr), StandardCharsets.UTF_8)) * 1000L;
            this.verifyUserId = params.get(QUERY_USER_ID);
            if (this.verifyUserId == null || this.verifyUserId.length() == 0) {
                logger.warn("{} is not exist", (Object)QUERY_USER_ID);
                return;
            }
            if (System.currentTimeMillis() >= this.validTime) {
                logger.info("verify config valid time is expired: valid time: {}, now: {}", (Object)new Date(this.validTime), (Object)new Date(System.currentTimeMillis()));
                return;
            }
            this.isValid = true;
            logger.info("verify config: valid time: {}, verifyUserId: {}", (Object)new Date(this.validTime), (Object)this.verifyUserId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("url is illegal", e);
        }
    }

    public static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException, UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return query_pairs;
    }

    public void request(String method, String url, String body, Map<String, String> headers) {
        HttpUriRequestBase httpRequest = new HttpUriRequestBase(method.toUpperCase(), URI.create(url));
        logger.debug(body);
        CloseableHttpResponse response = null;
        String requestId = HttpUtils.getXRequestID();
        try {
            StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
            httpRequest.addHeader((Header)new BasicHeader("X-Request-ID", (Object)requestId));
            if (headers != null) {
                headers.entrySet().stream().forEach(entry -> httpRequest.addHeader((Header)new BasicHeader((String)entry.getKey(), entry.getValue())));
            }
            httpRequest.setEntity((HttpEntity)entity);
            response = (CloseableHttpResponse)HttpUtils.getHttpClient().execute((ClassicHttpRequest)httpRequest);
            String resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (!VerifySender.isSuccess(response, resultStr)) {
                String causeMsg = String.format("verify HTTP ERROR, code: %s, resultStr: %s", response.getCode(), resultStr);
                logger.error(causeMsg);
                logger.error("verify request error: requestId={}, method={}, url={}, ,header={}, body=\r\n{}", new Object[]{requestId, method, url, headers, body});
            }
            logger.info("verify request success. result: {}", (Object)resultStr);
        }
        catch (Exception e) {
            String errorMsg = String.format("request error, parse error: requestId=%s, method=%s, url=%s, header={}, body=\r\n%s", requestId, method, url, headers, body);
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg, e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
    }

    private static boolean isSuccess(CloseableHttpResponse response, String resultStr) throws IOException {
        if (200 != response.getCode()) {
            return false;
        }
        Map object = RangersJSONConfig.getInstance().fromJson(resultStr, Map.class);
        if (object != null && object.containsKey("message") && "ok".equalsIgnoreCase(object.get("message").toString())) {
            logger.debug("Send Success.");
            logger.debug(resultStr);
            return true;
        }
        return false;
    }
}

